/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JStormHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(JStormHealthCheck.class);
    private static final Map<Integer, HealthCheckRegistry> taskHealthCheckMap = new ConcurrentHashMap<Integer, HealthCheckRegistry>();
    private static final HealthCheckRegistry workerHealthCheck = new HealthCheckRegistry();

    public static void registerTaskHealthCheck(int taskId, String name, HealthCheck healthCheck) {
        HealthCheckRegistry healthCheckRegister = taskHealthCheckMap.get(taskId);
        if (healthCheckRegister == null) {
            healthCheckRegister = new HealthCheckRegistry();
            taskHealthCheckMap.put(taskId, healthCheckRegister);
        }
        healthCheckRegister.register(name, healthCheck);
    }

    public static void registerWorkerHealthCheck(String name, HealthCheck healthCheck) {
        workerHealthCheck.register(name, healthCheck);
    }

    public static void unregisterTaskHealthCheck(int taskId, String name) {
        HealthCheckRegistry healthCheckRegister = taskHealthCheckMap.get(taskId);
        if (healthCheckRegister != null) {
            healthCheckRegister.unregister(name);
        }
    }

    public static void unregisterWorkerHealthCheck(String name) {
        workerHealthCheck.unregister(name);
    }

    public static Map<Integer, HealthCheckRegistry> getTaskhealthcheckmap() {
        return taskHealthCheckMap;
    }

    public static HealthCheckRegistry getWorkerhealthcheck() {
        return workerHealthCheck;
    }
}

