/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.cluster.StormClusterState;
import com.alibaba.jstorm.daemon.worker.WorkerData;
import com.alibaba.jstorm.metric.JStormHealthCheck;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.util.Map;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JStormHealthReporter
extends RunnableCallback {
    private static final Logger LOG = LoggerFactory.getLogger(JStormHealthReporter.class);
    private static final int THREAD_CYCLE = 60;
    private WorkerData workerData;

    public JStormHealthReporter(WorkerData workerData) {
        this.workerData = workerData;
    }

    @Override
    public void run() {
        StormClusterState clusterState = this.workerData.getZkCluster();
        String topologyId = this.workerData.getTopologyId();
        Map<Integer, HealthCheckRegistry> taskHealthCheckMap = JStormHealthCheck.getTaskhealthcheckmap();
        int cnt = 0;
        for (Map.Entry<Integer, HealthCheckRegistry> entry : taskHealthCheckMap.entrySet()) {
            Integer taskId = entry.getKey();
            SortedMap results = entry.getValue().runHealthChecks();
            for (Map.Entry result2 : results.entrySet()) {
                if (((HealthCheck.Result)result2.getValue()).isHealthy()) continue;
                try {
                    clusterState.report_task_error(topologyId, taskId, ((HealthCheck.Result)result2.getValue()).getMessage(), "warn", 100, 180);
                    ++cnt;
                }
                catch (Exception e) {
                    LOG.error("Failed to update health data in ZK for topo-{} task-{}.", new Object[]{topologyId, taskId, e});
                }
            }
        }
        LOG.info("Successfully updated {} health data to ZK for topology:{}", (Object)cnt, (Object)topologyId);
    }

    @Override
    public Object getResult() {
        return 60;
    }

    @Override
    public String getThreadName() {
        return "HealthReporterThread";
    }
}

