/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import backtype.storm.generated.MetricInfo;
import backtype.storm.generated.MetricSnapshot;
import com.alibaba.jstorm.common.metric.AsmCounter;
import com.alibaba.jstorm.common.metric.AsmGauge;
import com.alibaba.jstorm.common.metric.AsmHistogram;
import com.alibaba.jstorm.common.metric.AsmMeter;
import com.alibaba.jstorm.common.metric.AsmMetric;
import com.alibaba.jstorm.common.metric.snapshot.AsmSnapshot;
import com.alibaba.jstorm.metric.AsmMetricRegistry;
import com.alibaba.jstorm.metric.MetaType;
import com.alibaba.jstorm.metric.MetricType;
import com.alibaba.jstorm.metric.MetricUtils;
import com.alibaba.jstorm.utils.NetWorkUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JStormMetrics
implements Serializable {
    private static final long serialVersionUID = -2580242512743243267L;
    public static final String NIMBUS_METRIC_KEY = "__NIMBUS__";
    public static final String CLUSTER_METRIC_KEY = "__CLUSTER__";
    public static final String SUPERVISOR_METRIC_KEY = "__SUPERVISOR__";
    public static final String[] SYS_TOPOLOGIES = new String[]{"__NIMBUS__", "__CLUSTER__", "__SUPERVISOR__"};
    public static final Set<String> SYS_TOPOLOGY_SET = Sets.newHashSet((Object[])SYS_TOPOLOGIES);
    public static final String DEFAULT_GROUP = "sys";
    public static final String NETTY_GROUP = "netty";
    protected static final Logger LOG = LoggerFactory.getLogger(JStormMetrics.class);
    protected static final AsmMetricRegistry workerMetrics = new AsmMetricRegistry();
    protected static final AsmMetricRegistry nettyMetrics = new AsmMetricRegistry();
    protected static final AsmMetricRegistry componentMetrics = new AsmMetricRegistry();
    protected static final AsmMetricRegistry taskMetrics = new AsmMetricRegistry();
    protected static final AsmMetricRegistry streamMetrics = new AsmMetricRegistry();
    protected static final AsmMetricRegistry topologyMetrics = new AsmMetricRegistry();
    protected static final AsmMetricRegistry[] allRegistries = new AsmMetricRegistry[]{streamMetrics, taskMetrics, componentMetrics, workerMetrics, nettyMetrics, topologyMetrics};
    protected static String topologyId;
    protected static String host;
    protected static int port;
    protected static boolean debug;
    protected static Set<String> debugMetricNames;
    public static volatile boolean enabled;
    public static volatile boolean enableStreamMetrics;

    public static void setTimerUpdateInterval(long interval) {
        AsmHistogram.setUpdateInterval(interval);
    }

    public static int getPort() {
        return port;
    }

    public static void setPort(int port) {
        JStormMetrics.port = port;
    }

    public static String getHost() {
        return host;
    }

    public static void setHost(String host) {
        JStormMetrics.host = host;
    }

    public static String getTopologyId() {
        return topologyId;
    }

    public static void setTopologyId(String topologyId) {
        JStormMetrics.topologyId = topologyId;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        JStormMetrics.debug = debug;
        LOG.info("topology metrics debug enabled:{}", (Object)debug);
    }

    public static String workerMetricName(String name, MetricType type) {
        return MetricUtils.workerMetricName(topologyId, host, port, name, type);
    }

    public static void addDebugMetrics(String names) {
        String[] metrics;
        for (String metric : metrics = names.split(",")) {
            if (StringUtils.isBlank((String)(metric = metric.trim()))) continue;
            debugMetricNames.add(metric);
        }
        LOG.info("debug metric names:{}", (Object)Joiner.on((String)",").join(debugMetricNames));
    }

    public static AsmMetric find(String name) {
        for (AsmMetricRegistry registry : allRegistries) {
            AsmMetric metric = registry.getMetric(name);
            if (metric == null) continue;
            return metric;
        }
        return null;
    }

    public static AsmMetric registerStreamMetric(String name, AsmMetric metric, boolean mergeTopology) {
        name = JStormMetrics.fixNameIfPossible(name);
        LOG.info("register stream metric:{}", (Object)name);
        AsmMetric ret = streamMetrics.register(name, metric);
        if (metric.isAggregate()) {
            ArrayList<AsmMetric> assocMetrics = new ArrayList<AsmMetric>();
            String taskMetricName = MetricUtils.stream2taskName(name);
            AsmMetric taskMetric = taskMetrics.register(taskMetricName, metric.clone());
            assocMetrics.add(taskMetric);
            String compMetricName = MetricUtils.task2compName(taskMetricName);
            AsmMetric componentMetric = componentMetrics.register(compMetricName, taskMetric.clone());
            assocMetrics.add(componentMetric);
            String metricName = MetricUtils.getMetricName(name);
            if (metricName.contains(".")) {
                compMetricName = MetricUtils.task2MergeCompName(taskMetricName);
                AsmMetric mergeCompMetric = componentMetrics.register(compMetricName, taskMetric.clone());
                assocMetrics.add(mergeCompMetric);
            }
            if (mergeTopology) {
                String topologyMetricName = MetricUtils.comp2topologyName(compMetricName);
                AsmMetric topologyMetric = topologyMetrics.register(topologyMetricName, ret.clone());
                assocMetrics.add(topologyMetric);
            }
            ret.addAssocMetrics(assocMetrics.toArray(new AsmMetric[assocMetrics.size()]));
        }
        return ret;
    }

    public static AsmMetric registerTaskMetric(String name, AsmMetric metric) {
        name = JStormMetrics.fixNameIfPossible(name);
        AsmMetric ret = taskMetrics.register(name, metric);
        if (metric.isAggregate()) {
            String compMetricName = MetricUtils.task2compName(name);
            AsmMetric componentMetric = componentMetrics.register(compMetricName, ret.clone());
            ret.addAssocMetrics(componentMetric);
        }
        return ret;
    }

    public static AsmMetric registerWorkerMetric(String name, AsmMetric metric) {
        name = JStormMetrics.fixNameIfPossible(name);
        return workerMetrics.register(name, metric);
    }

    public static AsmMetric registerWorkerTopologyMetric(String name, AsmMetric metric) {
        name = JStormMetrics.fixNameIfPossible(name);
        AsmMetric ret = workerMetrics.register(name, metric);
        String topologyMetricName = MetricUtils.worker2topologyName(name);
        AsmMetric topologyMetric = topologyMetrics.register(topologyMetricName, ret.clone());
        ret.addAssocMetrics(topologyMetric);
        return ret;
    }

    public static AsmMetric registerNettyMetric(String name, AsmMetric metric) {
        name = JStormMetrics.fixNameIfPossible(name, NETTY_GROUP);
        return nettyMetrics.register(name, metric);
    }

    public static AsmHistogram registerWorkerHistogram(String topologyId, String name, AsmHistogram histogram) {
        return (AsmHistogram)JStormMetrics.registerWorkerMetric(MetricUtils.workerMetricName(topologyId, host, 0, name, MetricType.HISTOGRAM), histogram);
    }

    public static AsmGauge registerWorkerGauge(String topologyId, String name, AsmGauge gauge) {
        return (AsmGauge)JStormMetrics.registerWorkerMetric(MetricUtils.workerMetricName(topologyId, host, 0, name, MetricType.GAUGE), gauge);
    }

    public static AsmMeter registerWorkerMeter(String topologyId, String name, AsmMeter meter) {
        return (AsmMeter)JStormMetrics.registerWorkerMetric(MetricUtils.workerMetricName(topologyId, host, 0, name, MetricType.METER), meter);
    }

    public static AsmCounter registerWorkerCounter(String topologyId, String name, AsmCounter counter) {
        return (AsmCounter)JStormMetrics.registerWorkerMetric(MetricUtils.workerMetricName(topologyId, host, 0, name, MetricType.COUNTER), counter);
    }

    public static AsmMetric getStreamMetric(String name) {
        name = JStormMetrics.fixNameIfPossible(name);
        return streamMetrics.getMetric(name);
    }

    public static AsmMetric getTaskMetric(String name) {
        name = JStormMetrics.fixNameIfPossible(name);
        return taskMetrics.getMetric(name);
    }

    public static AsmMetric getComponentMetric(String name) {
        name = JStormMetrics.fixNameIfPossible(name);
        return componentMetrics.getMetric(name);
    }

    public static AsmMetric getWorkerMetric(String name) {
        name = JStormMetrics.fixNameIfPossible(name);
        return workerMetrics.getMetric(name);
    }

    public static void unregisterWorkerMetric(String name) {
        name = JStormMetrics.fixNameIfPossible(name);
        workerMetrics.remove(name);
    }

    public static void unregisterNettyMetric(String name) {
        name = JStormMetrics.fixNameIfPossible(name, NETTY_GROUP);
        nettyMetrics.remove(name);
    }

    public static void unregisterTaskMetric(String name) {
        name = JStormMetrics.fixNameIfPossible(name);
        taskMetrics.remove(name);
    }

    public static AsmMetricRegistry getNettyMetrics() {
        return nettyMetrics;
    }

    public static AsmMetricRegistry getWorkerMetrics() {
        return workerMetrics;
    }

    public static AsmMetricRegistry getComponentMetrics() {
        return componentMetrics;
    }

    public static AsmMetricRegistry getTaskMetrics() {
        return taskMetrics;
    }

    public static AsmMetricRegistry getStreamMetrics() {
        return streamMetrics;
    }

    public static AsmMetricRegistry getTopologyMetrics() {
        return topologyMetrics;
    }

    public static MetricInfo computeAllMetrics() {
        long start = System.currentTimeMillis();
        MetricInfo metricInfo = MetricUtils.mkMetricInfo();
        LinkedList entries = Lists.newLinkedList();
        if (enableStreamMetrics) {
            entries.addAll(JStormMetrics.streamMetrics.metrics.entrySet());
        }
        entries.addAll(JStormMetrics.taskMetrics.metrics.entrySet());
        entries.addAll(JStormMetrics.componentMetrics.metrics.entrySet());
        entries.addAll(JStormMetrics.workerMetrics.metrics.entrySet());
        entries.addAll(JStormMetrics.nettyMetrics.metrics.entrySet());
        entries.addAll(JStormMetrics.topologyMetrics.metrics.entrySet());
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            AsmMetric metric = (AsmMetric)entry.getValue();
            Map<Integer, AsmSnapshot> snapshots = metric.getSnapshots();
            if (snapshots.size() == 0) continue;
            int op = metric.getOp();
            if ((op & 1) == 1) {
                MetricUtils.printMetricSnapshot(metric, snapshots);
            }
            if ((op & 2) != 2) continue;
            MetaType metaType = MetricUtils.metaType(metric.getMetricName());
            try {
                Map<Integer, MetricSnapshot> data;
                if (metric instanceof AsmCounter) {
                    data = MetricUtils.toThriftCounterSnapshots(snapshots);
                    JStormMetrics.putIfNotEmpty(metricInfo.get_metrics(), name, data);
                    continue;
                }
                if (metric instanceof AsmGauge) {
                    data = MetricUtils.toThriftGaugeSnapshots(snapshots);
                    JStormMetrics.putIfNotEmpty(metricInfo.get_metrics(), name, data);
                    continue;
                }
                if (metric instanceof AsmMeter) {
                    data = MetricUtils.toThriftMeterSnapshots(snapshots);
                    JStormMetrics.putIfNotEmpty(metricInfo.get_metrics(), name, data);
                    continue;
                }
                if (!(metric instanceof AsmHistogram)) continue;
                data = MetricUtils.toThriftHistoSnapshots(metaType, snapshots);
                JStormMetrics.putIfNotEmpty(metricInfo.get_metrics(), name, data);
            }
            catch (Exception ex) {
                LOG.error("Error", (Throwable)ex);
            }
        }
        if (debug) {
            MetricUtils.printMetricInfo(metricInfo, debugMetricNames);
        }
        LOG.info("compute all metrics, cost:{}", (Object)(System.currentTimeMillis() - start));
        return metricInfo;
    }

    public static <T extends Map> void putIfNotEmpty(Map base, String name, T data) {
        if (data != null && data.size() > 0) {
            base.put(name, data);
        }
    }

    public static String fixNameIfPossible(String name) {
        return JStormMetrics.fixNameIfPossible(name, DEFAULT_GROUP);
    }

    public static String fixNameIfPossible(String name, String group) {
        MetaType type = MetricUtils.metaType(name);
        Object[] parts = name.split("@");
        if (parts[1].equals("")) {
            parts[1] = topologyId;
        }
        if (type != MetaType.WORKER && parts[5].equals("")) {
            parts[5] = group;
        } else if (parts[2].equals("")) {
            parts[2] = host;
            parts[3] = port + "";
            if (((String)parts[4]).equals("")) {
                parts[4] = group;
            }
        }
        return MetricUtils.concat(parts);
    }

    public static void main(String[] args) throws Exception {
        topologyId = "topologyId";
        host = "127.0.0.1";
        port = 6800;
        String tpId = "test";
        String compName = "bolt";
        int taskId = 1;
        String streamId = "defaultStream";
        String type = MetaType.STREAM.getV() + MetricType.COUNTER.getV();
        String metricName = "counter1";
        String group = "udf";
        String name = MetricUtils.metricName(type, tpId, compName, taskId, streamId, group, metricName);
        System.out.println(name);
        AsmCounter counter = new AsmCounter();
        AsmMetric ret1 = JStormMetrics.registerStreamMetric(name, counter, false);
        AsmMetric ret2 = JStormMetrics.registerStreamMetric(name, counter, false);
        System.out.println(ret1 == ret2);
        counter.update(1L);
        metricName = MetricUtils.workerMetricName("metric1", MetricType.COUNTER);
        System.out.println(metricName);
        metricName = JStormMetrics.fixNameIfPossible(metricName);
        System.out.println(metricName);
        System.out.println(JStormMetrics.fixNameIfPossible(metricName));
    }

    static {
        debugMetricNames = new HashSet<String>();
        host = NetWorkUtils.ip();
        enabled = true;
        enableStreamMetrics = true;
    }
}

