/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import java.util.HashMap;
import java.util.Map;

public enum MetaType {
    TASK(1, "T"),
    COMPONENT(2, "C"),
    STREAM(3, "S"),
    WORKER(4, "W"),
    TOPOLOGY(5, "P"),
    NETTY(6, "N"),
    NIMBUS(7, "M");

    private int t;
    private String v;
    private static final Map<String, MetaType> valueMap;
    private static final Map<Integer, MetaType> typeMap;

    private MetaType(int t, String v) {
        this.t = t;
        this.v = v;
    }

    public String getV() {
        return this.v;
    }

    public int getT() {
        return this.t;
    }

    public static MetaType parse(char ch) {
        return MetaType.parse(ch + "");
    }

    public static MetaType parse(String v) {
        return valueMap.get(v);
    }

    public static MetaType parse(int t) {
        return typeMap.get(t);
    }

    static {
        valueMap = new HashMap<String, MetaType>();
        typeMap = new HashMap<Integer, MetaType>();
        for (MetaType type : MetaType.values()) {
            typeMap.put(type.getT(), type);
            valueMap.put(type.getV(), type);
        }
    }
}

