/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import backtype.storm.task.TopologyContext;
import com.alibaba.jstorm.common.metric.AsmCounter;
import com.alibaba.jstorm.common.metric.AsmGauge;
import com.alibaba.jstorm.common.metric.AsmHistogram;
import com.alibaba.jstorm.common.metric.AsmMeter;
import com.alibaba.jstorm.metric.JStormMetrics;
import com.alibaba.jstorm.metric.MetricType;
import com.alibaba.jstorm.metric.MetricUtils;
import com.codahale.metrics.Gauge;

public class MetricClient {
    private static final String GROUP_UDF = "udf";
    private final String topologyId;
    private final String componentId;
    private final int taskId;

    public MetricClient(TopologyContext context) {
        this.taskId = context.getThisTaskId();
        this.topologyId = context.getTopologyId();
        this.componentId = context.getThisComponentId();
    }

    public AsmGauge registerGauge(String name, Gauge<Double> gauge) {
        return this.registerGauge(name, GROUP_UDF, gauge);
    }

    public AsmGauge registerGauge(String name, String group, Gauge<Double> gauge) {
        String userMetricName = this.getMetricName(name, group, MetricType.GAUGE);
        AsmGauge asmGauge = new AsmGauge(gauge);
        JStormMetrics.registerTaskMetric(userMetricName, asmGauge);
        return asmGauge;
    }

    public AsmCounter registerCounter(String name) {
        return this.registerCounter(name, GROUP_UDF);
    }

    public AsmCounter registerCounter(String name, String group) {
        String userMetricName = this.getMetricName(name, group, MetricType.COUNTER);
        AsmCounter counter = new AsmCounter();
        JStormMetrics.registerTaskMetric(userMetricName, counter);
        return counter;
    }

    public AsmMeter registerMeter(String name) {
        return this.registerMeter(name, GROUP_UDF);
    }

    public AsmMeter registerMeter(String name, String group) {
        String userMetricName = this.getMetricName(name, group, MetricType.METER);
        return (AsmMeter)JStormMetrics.registerTaskMetric(userMetricName, new AsmMeter());
    }

    public AsmHistogram registerHistogram(String name) {
        return this.registerHistogram(name, GROUP_UDF);
    }

    public AsmHistogram registerHistogram(String name, String group) {
        String userMetricName = this.getMetricName(name, group, MetricType.HISTOGRAM);
        return (AsmHistogram)JStormMetrics.registerTaskMetric(userMetricName, new AsmHistogram());
    }

    public void unregister(String name, MetricType type) {
        this.unregister(name, GROUP_UDF, type);
    }

    public void unregister(String name, String group, MetricType type) {
        String userMetricName = this.getMetricName(name, group, type);
        JStormMetrics.unregisterTaskMetric(userMetricName);
    }

    private String getMetricName(String name, MetricType type) {
        return this.getMetricName(name, GROUP_UDF, type);
    }

    private String getMetricName(String name, String group, MetricType type) {
        return MetricUtils.taskMetricName(this.topologyId, this.componentId, this.taskId, group, name, type);
    }
}

