/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import java.util.HashMap;
import java.util.Map;

public enum MetricType {
    COUNTER("C", 1),
    GAUGE("G", 2),
    METER("M", 3),
    HISTOGRAM("H", 4),
    TIMER("T", 5);

    private String v;
    private int t;
    private static final Map<String, MetricType> valueMap;
    private static final Map<Integer, MetricType> typeMap;

    private MetricType(String v, int t) {
        this.v = v;
        this.t = t;
    }

    public int getT() {
        return this.t;
    }

    public String getV() {
        return this.v;
    }

    public static MetricType parse(char ch) {
        return MetricType.parse(ch + "");
    }

    public static MetricType parse(String s) {
        return valueMap.get(s);
    }

    public static MetricType parse(int t) {
        return typeMap.get(t);
    }

    static {
        valueMap = new HashMap<String, MetricType>();
        typeMap = new HashMap<Integer, MetricType>();
        for (MetricType type : MetricType.values()) {
            typeMap.put(type.getT(), type);
            valueMap.put(type.getV(), type);
        }
    }
}

