/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import backtype.storm.generated.MetricInfo;
import backtype.storm.generated.MetricSnapshot;
import backtype.storm.generated.TopologyMetric;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.common.metric.AsmMetric;
import com.alibaba.jstorm.common.metric.snapshot.AsmCounterSnapshot;
import com.alibaba.jstorm.common.metric.snapshot.AsmGaugeSnapshot;
import com.alibaba.jstorm.common.metric.snapshot.AsmHistogramSnapshot;
import com.alibaba.jstorm.common.metric.snapshot.AsmMeterSnapshot;
import com.alibaba.jstorm.common.metric.snapshot.AsmSnapshot;
import com.alibaba.jstorm.metric.AsmWindow;
import com.alibaba.jstorm.metric.Bytes;
import com.alibaba.jstorm.metric.MetaType;
import com.alibaba.jstorm.metric.MetricType;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.TimeUtils;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetricUtils.class);
    public static final char AT = '@';
    public static final String DELIM = "@";
    public static final String EMPTY = "";
    public static final String DEFAULT_GROUP = "sys";
    public static final int NETTY_METRIC_PAGE_SIZE = 200;

    public static boolean isValidId(long metricId) {
        return metricId != 0L;
    }

    public static MetricInfo mkMetricInfo() {
        MetricInfo ret = new MetricInfo();
        ret.set_metrics(new HashMap<String, Map<Integer, MetricSnapshot>>());
        return ret;
    }

    public static TopologyMetric mkTopologyMetric() {
        TopologyMetric emptyTopologyMetric = new TopologyMetric();
        emptyTopologyMetric.set_topologyMetric(new MetricInfo());
        emptyTopologyMetric.set_componentMetric(new MetricInfo());
        emptyTopologyMetric.set_workerMetric(new MetricInfo());
        emptyTopologyMetric.set_taskMetric(new MetricInfo());
        emptyTopologyMetric.set_streamMetric(new MetricInfo());
        emptyTopologyMetric.set_nettyMetric(new MetricInfo());
        return emptyTopologyMetric;
    }

    public static boolean isEnableNettyMetrics(Map stormConf) {
        boolean enableMetrics = ConfigExtension.isEnableMetrics(stormConf);
        if (!enableMetrics) {
            return false;
        }
        int maxWorkerNumForNetty = ConfigExtension.getTopologyMaxWorkerNumForNettyMetrics(stormConf);
        int workerNum = JStormUtils.parseInt(stormConf.get("topology.workers"), 1);
        return workerNum < maxWorkerNumForNetty;
    }

    public static String metricName(String type, String topologyId, String componentId, int taskId, String streamId, String group, String name) {
        return MetricUtils.concat(type, topologyId, componentId, taskId, streamId, group, name);
    }

    public static String streamMetricName(String topologyId, String componentId, int taskId, String streamId, String name, MetricType type) {
        return MetricUtils.concat(MetaType.STREAM.getV() + type.getV(), topologyId, componentId, taskId, streamId, DEFAULT_GROUP, name);
    }

    public static String workerMetricName(String topologyId, String host, int port, String name, MetricType type) {
        return MetricUtils.concat(MetaType.WORKER.getV() + type.getV(), topologyId, host, port, DEFAULT_GROUP, name);
    }

    public static String workerMetricName(String name, MetricType type) {
        return MetricUtils.concat(MetaType.WORKER.getV() + type.getV(), EMPTY, EMPTY, 0, DEFAULT_GROUP, name);
    }

    public static String nettyMetricName(String name, MetricType type) {
        return MetricUtils.concat(MetaType.NETTY.getV() + type.getV(), EMPTY, EMPTY, 0, "netty", name);
    }

    public static String workerMetricPrefix(String topologyId, String host, int port) {
        return MetricUtils.concat(MetaType.WORKER.getV(), topologyId, host, port);
    }

    public static String taskMetricName(String topologyId, String componentId, int taskId, String name, MetricType type) {
        return MetricUtils.concat(MetaType.TASK.getV() + type.getV(), topologyId, componentId, taskId, EMPTY, DEFAULT_GROUP, name);
    }

    public static String taskMetricName(String topologyId, String componentId, int taskId, String group, String name, MetricType type) {
        return MetricUtils.concat(MetaType.TASK.getV() + type.getV(), topologyId, componentId, taskId, EMPTY, group, name);
    }

    public static String compMetricName(String topologyId, String componentId, String name, MetricType type) {
        return MetricUtils.concat(MetaType.COMPONENT.getV() + type.getV(), topologyId, componentId, 0, EMPTY, DEFAULT_GROUP, name);
    }

    public static String removeDelimIfPossible(String name) {
        if (name.contains(DELIM)) {
            return name.replace(DELIM, EMPTY);
        }
        return name;
    }

    public static MetaType metaType(String name) {
        return MetaType.parse(name.charAt(0) + EMPTY);
    }

    public static MetricType metricType(String name) {
        return MetricType.parse(name.charAt(1) + EMPTY);
    }

    public static String stream2taskName(String old) {
        Object[] parts = old.split(DELIM);
        if (parts.length >= 7) {
            parts[0] = MetaType.TASK.getV() + ((String)parts[0]).charAt(1);
            parts[parts.length - 3] = EMPTY;
        }
        return MetricUtils.concat(parts);
    }

    public static String task2compName(String old) {
        Object[] parts = old.split(DELIM);
        if (parts.length >= 7) {
            parts[0] = MetaType.COMPONENT.getV() + ((String)parts[0]).charAt(1);
            parts[parts.length - 3] = EMPTY;
            parts[parts.length - 4] = "0";
        }
        return MetricUtils.concat(parts);
    }

    public static String task2MergeCompName(String old) {
        Object[] parts = old.split(DELIM);
        if (parts.length >= 7) {
            parts[0] = MetaType.COMPONENT.getV() + ((String)parts[0]).charAt(1);
            parts[parts.length - 3] = EMPTY;
            parts[parts.length - 4] = "0";
            Object metricName = parts[parts.length - 1];
            int dotIndex = ((String)metricName).indexOf(".");
            if (dotIndex != -1) {
                parts[parts.length - 1] = metricName = ((String)metricName).substring(dotIndex + 1);
            }
        }
        return MetricUtils.concat(parts);
    }

    public static String comp2topologyName(String old) {
        String[] parts = old.split(DELIM);
        parts[0] = MetaType.TOPOLOGY.getV() + parts[0].charAt(1);
        return MetricUtils.concat(parts[0], parts[1], EMPTY, "0", parts[5], parts[6]);
    }

    public static String worker2topologyName(String old) {
        Object[] parts = old.split(DELIM);
        if (parts.length >= 5) {
            parts[0] = MetaType.TOPOLOGY.getV() + ((String)parts[0]).charAt(1);
            parts[2] = EMPTY;
            parts[3] = "0";
        }
        return MetricUtils.concat(parts);
    }

    public static String topo2clusterName(String old) {
        Object[] parts = old.split(DELIM);
        parts[1] = "__CLUSTER__";
        return MetricUtils.concat(parts);
    }

    public static String concat(Object ... args) {
        StringBuilder sb = new StringBuilder(50);
        int last = args.length - 1;
        if (args[last] instanceof String) {
            args[last] = MetricUtils.removeDelimIfPossible((String)args[last]);
        }
        for (Object arg : args) {
            sb.append(arg).append(DELIM);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String concat2(Object ... args) {
        StringBuilder sb = new StringBuilder(50);
        for (Object arg : args) {
            sb.append(arg).append(DELIM);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static String concat3(String delim, Object ... args) {
        StringBuilder sb = new StringBuilder(50);
        for (Object arg : args) {
            sb.append(arg).append(delim);
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static Histogram metricSnapshot2Histogram(MetricSnapshot snapshot) {
        Histogram histogram = new Histogram((Reservoir)new ExponentiallyDecayingReservoir());
        byte[] points = snapshot.get_points();
        int len = snapshot.get_pointSize();
        MetricUtils.updateHistogramPoints(histogram, points, len);
        return histogram;
    }

    public static void updateHistogramPoints(Histogram histogram, byte[] points, int len) {
        if (points != null && len > 0) {
            for (int i = 0; i < len; ++i) {
                long pt = Bytes.toLong(points, i * 8, 8);
                histogram.update(pt);
            }
        }
    }

    public static Map<Integer, MetricSnapshot> toThriftCounterSnapshots(Map<Integer, AsmSnapshot> snapshots) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)snapshots.size());
        for (Map.Entry<Integer, AsmSnapshot> entry : snapshots.entrySet()) {
            ret.put(entry.getKey(), MetricUtils.convert((AsmCounterSnapshot)entry.getValue()));
        }
        return ret;
    }

    public static Map<Integer, MetricSnapshot> toThriftGaugeSnapshots(Map<Integer, AsmSnapshot> snapshots) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)snapshots.size());
        for (Map.Entry<Integer, AsmSnapshot> entry : snapshots.entrySet()) {
            ret.put(entry.getKey(), MetricUtils.convert((AsmGaugeSnapshot)entry.getValue()));
        }
        return ret;
    }

    public static Map<Integer, MetricSnapshot> toThriftMeterSnapshots(Map<Integer, AsmSnapshot> snapshots) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)snapshots.size());
        for (Map.Entry<Integer, AsmSnapshot> entry : snapshots.entrySet()) {
            ret.put(entry.getKey(), MetricUtils.convert((AsmMeterSnapshot)entry.getValue()));
        }
        return ret;
    }

    public static Map<Integer, MetricSnapshot> toThriftHistoSnapshots(MetaType metaType, Map<Integer, AsmSnapshot> snapshots) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)snapshots.size());
        for (Map.Entry<Integer, AsmSnapshot> entry : snapshots.entrySet()) {
            MetricSnapshot histogramSnapshot = MetricUtils.convert(metaType, (AsmHistogramSnapshot)entry.getValue());
            if (histogramSnapshot == null) continue;
            ret.put(entry.getKey(), histogramSnapshot);
        }
        return ret;
    }

    public static MetricSnapshot convert(AsmCounterSnapshot snapshot) {
        MetricSnapshot ret = new MetricSnapshot();
        ret.set_metricId(snapshot.getMetricId());
        ret.set_ts(TimeUtils.alignTimeToMin(snapshot.getTs()));
        ret.set_metricType(MetricType.COUNTER.getT());
        ret.set_longValue(snapshot.getV());
        return ret;
    }

    public static MetricSnapshot convert(AsmGaugeSnapshot snapshot) {
        MetricSnapshot ret = new MetricSnapshot();
        ret.set_metricId(snapshot.getMetricId());
        ret.set_ts(TimeUtils.alignTimeToMin(snapshot.getTs()));
        ret.set_metricType(MetricType.GAUGE.getT());
        ret.set_doubleValue(snapshot.getV());
        return ret;
    }

    public static MetricSnapshot convert(AsmMeterSnapshot snapshot) {
        MetricSnapshot ret = new MetricSnapshot();
        ret.set_metricId(snapshot.getMetricId());
        ret.set_ts(TimeUtils.alignTimeToMin(snapshot.getTs()));
        ret.set_metricType(MetricType.METER.getT());
        ret.set_m1(snapshot.getM1());
        ret.set_m5(snapshot.getM5());
        ret.set_m15(snapshot.getM15());
        ret.set_mean(snapshot.getMean());
        return ret;
    }

    public static MetricSnapshot convert(MetaType metaType, AsmHistogramSnapshot snapshot) {
        MetricSnapshot ret = new MetricSnapshot();
        ret.set_metricId(snapshot.getMetricId());
        ret.set_ts(TimeUtils.alignTimeToMin(snapshot.getTs()));
        ret.set_metricType(MetricType.HISTOGRAM.getT());
        Snapshot ws = snapshot.getSnapshot();
        ret.set_min(ws.getMin());
        ret.set_max(ws.getMax());
        ret.set_p50(ws.getMedian());
        ret.set_p75(ws.get75thPercentile());
        ret.set_p95(ws.get95thPercentile());
        ret.set_p98(ws.get98thPercentile());
        ret.set_p99(ws.get99thPercentile());
        ret.set_p999(ws.get999thPercentile());
        ret.set_mean(ws.getMean());
        ret.set_stddev(ws.getStdDev());
        if (metaType == MetaType.COMPONENT || metaType == MetaType.TOPOLOGY) {
            byte[] points = MetricUtils.longs2bytes(ws.getValues());
            ret.set_points(points);
            ret.set_pointSize(ws.getValues().length);
        } else {
            ret.set_points(new byte[0]);
            ret.set_pointSize(0);
        }
        return ret;
    }

    public static byte[] longs2bytes(long[] points) {
        int len = points.length;
        byte[] bytePts = new byte[len * 8];
        for (int i = 0; i < len; ++i) {
            Bytes.putLong(bytePts, i * 8, points[i]);
        }
        return bytePts;
    }

    public static String getMetricName(String fullName) {
        String[] parts = fullName.split(DELIM);
        return parts[parts.length - 1];
    }

    public static String str(Object obj) {
        if (obj instanceof MetricSnapshot) {
            MetricSnapshot snapshot = (MetricSnapshot)obj;
            MetricType type = MetricType.parse(snapshot.get_metricType());
            if (type == MetricType.COUNTER) {
                return MetricUtils.counterStr(snapshot);
            }
            if (type == MetricType.GAUGE) {
                return MetricUtils.gaugeStr(snapshot);
            }
            if (type == MetricType.METER) {
                return MetricUtils.meterStr(snapshot);
            }
            if (type == MetricType.HISTOGRAM) {
                return MetricUtils.histogramStr(snapshot);
            }
        }
        return obj.toString();
    }

    public static String counterStr(MetricSnapshot snapshot) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("id:").append(snapshot.get_metricId()).append(",v:").append(snapshot.get_longValue());
        return sb.toString();
    }

    public static String gaugeStr(MetricSnapshot snapshot) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("id:").append(snapshot.get_metricId()).append(",v:").append(snapshot.get_doubleValue());
        return sb.toString();
    }

    public static String meterStr(MetricSnapshot snapshot) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("id:").append(snapshot.get_metricId());
        sb.append(",m1:").append(snapshot.get_m1()).append(",m5:").append(snapshot.get_m5()).append(",m15:").append(snapshot.get_m15()).append(",mean:").append(snapshot.get_mean());
        return sb.toString();
    }

    public static String histogramStr(MetricSnapshot snapshot) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("histogram");
        sb.append("(").append("id:").append(snapshot.get_metricId()).append(",min:").append(snapshot.get_min()).append(",max:").append(snapshot.get_max()).append(",mean:").append(snapshot.get_mean()).append(",p50:").append(snapshot.get_p50()).append(",p75:").append(snapshot.get_p75()).append(",p95:").append(snapshot.get_p95()).append(",p98:").append(snapshot.get_p98()).append(",p99:").append(snapshot.get_p99()).append(",pts:").append(snapshot.get_pointSize()).append(")");
        return sb.toString();
    }

    public static void printMetricSnapshot(AsmMetric metric, Map<Integer, AsmSnapshot> snapshots) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("metric:").append(metric.getMetricName()).append(", ");
        for (Map.Entry<Integer, AsmSnapshot> entry : snapshots.entrySet()) {
            sb.append("win:").append(entry.getKey()).append(", v:").append(MetricUtils.getSnapshotDefaultValue(entry.getValue())).append("; ");
        }
        LOG.info(sb.toString());
    }

    public static double getSnapshotDefaultValue(AsmSnapshot snapshot) {
        if (snapshot instanceof AsmCounterSnapshot) {
            return ((AsmCounterSnapshot)snapshot).getV();
        }
        if (snapshot instanceof AsmGaugeSnapshot) {
            return ((AsmGaugeSnapshot)snapshot).getV();
        }
        if (snapshot instanceof AsmMeterSnapshot) {
            return ((AsmMeterSnapshot)snapshot).getM1();
        }
        if (snapshot instanceof AsmHistogramSnapshot) {
            return ((AsmHistogramSnapshot)snapshot).getSnapshot().getMean();
        }
        return 0.0;
    }

    public static void printMetricInfo(MetricInfo metricInfo) {
        MetricUtils.iterateMap(metricInfo.get_metrics());
    }

    public static void printMetricInfo(MetricInfo metricInfo, Set<String> metrics) {
        MetricUtils.iterateMap(metricInfo.get_metrics(), metrics);
    }

    public static <T> void iterateMap(Map<String, Map<Integer, T>> map) {
        MetricUtils.iterateMap(map, null);
    }

    public static <T> void iterateMap(Map<String, Map<Integer, T>> map, Set<String> metrics) {
        for (Map.Entry<String, Map<Integer, T>> entry : map.entrySet()) {
            String name = entry.getKey();
            boolean print = false;
            if (metrics == null) {
                print = true;
            } else {
                for (String metric : metrics) {
                    if (!name.contains(metric)) continue;
                    print = true;
                    break;
                }
            }
            if (!print) continue;
            Map<Integer, T> winData = entry.getValue();
            for (Map.Entry<Integer, T> win : winData.entrySet()) {
                T v = win.getValue();
                String str = v instanceof MetricSnapshot ? MetricUtils.str(v) : v.toString();
                LOG.info("metric:{}, win:{}, data:{}", new Object[]{name, win.getKey(), str});
            }
        }
    }

    private static <T> void iter(Map<String, T> map, Func func, Object ... args) {
        for (Map.Entry<String, T> entry : map.entrySet()) {
            func.exec(entry, args);
        }
    }

    public static void logMetrics(MetricInfo metricInfo) {
        Map<String, Map<Integer, MetricSnapshot>> metrics = metricInfo.get_metrics();
        if (metrics != null) {
            LOG.info("\nprint metrics:");
            for (Map.Entry<String, Map<Integer, MetricSnapshot>> entry : metrics.entrySet()) {
                String name = entry.getKey();
                MetricSnapshot metricSnapshot = entry.getValue().get(AsmWindow.M1_WINDOW);
                if (metricSnapshot == null) continue;
                MetricType metricType = MetricType.parse(metricSnapshot.get_metricType());
                double v = metricType == MetricType.COUNTER ? (double)metricSnapshot.get_longValue() : (metricType == MetricType.GAUGE ? metricSnapshot.get_doubleValue() : (metricType == MetricType.METER ? metricSnapshot.get_m1() : (metricType == MetricType.HISTOGRAM ? metricSnapshot.get_mean() : 0.0)));
                LOG.info("{}|{}|{}", new Object[]{metricType, v, name});
            }
            LOG.info("\n");
        }
    }

    public static interface Func {
        public void exec(Object ... var1);
    }
}

