/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import com.alibaba.jstorm.common.metric.AsmCounter;
import com.alibaba.jstorm.common.metric.AsmGauge;
import com.alibaba.jstorm.common.metric.AsmHistogram;
import com.alibaba.jstorm.common.metric.AsmMeter;
import com.alibaba.jstorm.metric.AsmMetricRegistry;
import com.alibaba.jstorm.metric.JStormMetrics;
import com.alibaba.jstorm.metric.MetricType;
import com.alibaba.jstorm.metric.MetricUtils;
import com.codahale.metrics.Gauge;

public class SimpleJStormMetric
extends JStormMetrics {
    private static final long serialVersionUID = 7468005641982249536L;
    protected static final AsmMetricRegistry metrics = JStormMetrics.getWorkerMetrics();

    public static void updateNimbusHistogram(String name, Number obj) {
        SimpleJStormMetric.updateHistogram("__NIMBUS__", name, obj);
    }

    public static void updateSupervisorHistogram(String name, Number obj) {
        SimpleJStormMetric.updateHistogram("__SUPERVISOR__", name, obj);
    }

    public static void updateNimbusMeter(String name, Number obj) {
        SimpleJStormMetric.updateMeter("__NIMBUS__", name, obj);
    }

    public static void updateSupervisorMeter(String name, Number obj) {
        SimpleJStormMetric.updateMeter("__SUPERVISOR__", name, obj);
    }

    public static void updateNimbusCounter(String name, Number obj) {
        SimpleJStormMetric.updateCounter("__NIMBUS__", name, obj);
    }

    public static void updateSupervisorCounter(String name, Number obj) {
        SimpleJStormMetric.updateCounter("__SUPERVISOR__", name, obj);
    }

    public static void updateHistogram(String key, String name, Number obj) {
        String formalName = MetricUtils.workerMetricName(key, host, 0, name, MetricType.HISTOGRAM);
        AsmHistogram histogram = (AsmHistogram)metrics.getMetric(formalName);
        if (histogram == null) {
            histogram = SimpleJStormMetric.registerHistogram(name);
        }
        histogram.update(obj);
    }

    public static void updateMeter(String key, String name, Number obj) {
        String formalName = MetricUtils.workerMetricName(key, host, 0, name, MetricType.METER);
        AsmMeter meter = (AsmMeter)metrics.getMetric(formalName);
        if (meter == null) {
            meter = SimpleJStormMetric.registerMeter(name);
        }
        meter.update(obj);
    }

    public static void updateCounter(String key, String name, Number obj) {
        String formalName = MetricUtils.workerMetricName(key, host, 0, name, MetricType.COUNTER);
        AsmCounter counter = (AsmCounter)metrics.getMetric(formalName);
        if (counter == null) {
            counter = SimpleJStormMetric.registerCounter(name);
        }
        counter.update(obj);
    }

    private static AsmGauge registerGauge(Gauge<Double> gauge, String name) {
        AsmGauge gauge1 = new AsmGauge(gauge);
        gauge1.setOp(1);
        return SimpleJStormMetric.registerWorkerGauge(topologyId, name, gauge1);
    }

    private static AsmHistogram registerHistogram(String name) {
        AsmHistogram histogram = new AsmHistogram();
        histogram.setOp(1);
        return SimpleJStormMetric.registerWorkerHistogram("__NIMBUS__", name, histogram);
    }

    public static AsmMeter registerMeter(String name) {
        AsmMeter meter = new AsmMeter();
        meter.setOp(1);
        return SimpleJStormMetric.registerWorkerMeter("__NIMBUS__", name, meter);
    }

    public static AsmCounter registerCounter(String name) {
        AsmCounter counter = new AsmCounter();
        counter.setOp(1);
        return SimpleJStormMetric.registerWorkerCounter("__NIMBUS__", name, counter);
    }
}

