/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import java.util.concurrent.TimeUnit;

public class TimeTicker {
    private TimeUnit unit;
    private long start;
    private long end;

    public TimeTicker(TimeUnit unit) {
        if (unit != TimeUnit.NANOSECONDS && unit != TimeUnit.MILLISECONDS) {
            throw new IllegalArgumentException("invalid unit!");
        }
        this.unit = unit;
    }

    public TimeTicker(TimeUnit unit, boolean start) {
        this(unit);
        if (start) {
            this.start();
        }
    }

    public void start() {
        if (this.unit == TimeUnit.MILLISECONDS) {
            this.start = System.currentTimeMillis();
        } else if (this.unit == TimeUnit.NANOSECONDS) {
            this.start = System.nanoTime();
        }
    }

    public long stop() {
        if (this.unit == TimeUnit.MILLISECONDS) {
            this.end = System.currentTimeMillis();
        } else if (this.unit == TimeUnit.NANOSECONDS) {
            this.end = System.nanoTime();
        }
        return this.end - this.start;
    }

    public long stopAndRestart() {
        long elapsed = this.stop();
        this.start();
        return elapsed;
    }
}

