/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.metric;

import backtype.storm.generated.MetricInfo;
import backtype.storm.generated.MetricSnapshot;
import backtype.storm.generated.TopologyMetric;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.metric.MetaType;
import com.alibaba.jstorm.metric.MetricType;
import com.alibaba.jstorm.metric.MetricUtils;
import com.alibaba.jstorm.schedule.default_assign.ResourceWorkerSlot;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Snapshot;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyMetricContext {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final ReentrantLock lock = new ReentrantLock();
    private Set<ResourceWorkerSlot> workerSet;
    private int taskNum = 1;
    private ConcurrentMap<String, MetricInfo> memCache = new ConcurrentHashMap<String, MetricInfo>();
    private final ConcurrentMap<String, Long> memMeta = new ConcurrentHashMap<String, Long>();
    private final AtomicBoolean isMerging = new AtomicBoolean(false);
    private String topologyId;
    private volatile int flushedMetaNum = 0;
    private volatile boolean syncMeta = false;
    private Map conf;

    public TopologyMetricContext() {
    }

    public TopologyMetricContext(Set<ResourceWorkerSlot> workerSet) {
        this.workerSet = workerSet;
    }

    public TopologyMetricContext(String topologyId, Set<ResourceWorkerSlot> workerSet, Map conf) {
        this(workerSet);
        this.topologyId = topologyId;
        this.conf = conf;
    }

    public ConcurrentMap<String, Long> getMemMeta() {
        return this.memMeta;
    }

    public String getTopologyId() {
        return this.topologyId;
    }

    public void setTopologyId(String topologyId) {
        this.topologyId = topologyId;
    }

    public boolean syncMeta() {
        return this.syncMeta;
    }

    public void setSyncMeta(boolean syncMeta) {
        this.syncMeta = syncMeta;
    }

    public int getTaskNum() {
        return this.taskNum;
    }

    public void setTaskNum(int taskNum) {
        this.taskNum = taskNum;
    }

    public int getFlushedMetaNum() {
        return this.flushedMetaNum;
    }

    public void setFlushedMetaNum(int flushedMetaNum) {
        this.flushedMetaNum = flushedMetaNum;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public int getWorkerNum() {
        return this.workerSet.size();
    }

    public void setWorkerSet(Set<ResourceWorkerSlot> workerSet) {
        this.workerSet = workerSet;
    }

    public void resetUploadedMetrics() {
        this.memCache.clear();
    }

    public final ConcurrentMap<String, MetricInfo> getMemCache() {
        return this.memCache;
    }

    public void addToMemCache(String workerSlot, MetricInfo metricInfo) {
        this.memCache.put(workerSlot, metricInfo);
        this.LOG.info("update mem cache, worker:{}, total uploaded:{}", (Object)workerSlot, (Object)this.memCache.size());
    }

    public boolean readyToUpload() {
        return this.memCache.size() >= this.workerSet.size();
    }

    public boolean isMerging() {
        return this.isMerging.get();
    }

    public void setMerging(boolean isMerging) {
        this.isMerging.set(isMerging);
    }

    public int getUploadedWorkerNum() {
        return this.memCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopologyMetric mergeMetrics() {
        long start = System.currentTimeMillis();
        if (this.getMemCache().size() == 0) {
            return null;
        }
        if (this.isMerging()) {
            this.LOG.info("topology {} is already merging, skip...", (Object)this.topologyId);
            return null;
        }
        this.setMerging(true);
        try {
            ConcurrentMap<String, MetricInfo> workerMetricMap = this.memCache;
            this.memCache = new ConcurrentHashMap<String, MetricInfo>();
            MetricInfo topologyMetrics = MetricUtils.mkMetricInfo();
            MetricInfo componentMetrics = MetricUtils.mkMetricInfo();
            MetricInfo taskMetrics = MetricUtils.mkMetricInfo();
            MetricInfo streamMetrics = MetricUtils.mkMetricInfo();
            MetricInfo workerMetrics = MetricUtils.mkMetricInfo();
            MetricInfo nettyMetrics = MetricUtils.mkMetricInfo();
            TopologyMetric tpMetric = new TopologyMetric(topologyMetrics, componentMetrics, workerMetrics, taskMetrics, streamMetrics, nettyMetrics);
            HashMap<String, Integer> metricNameCounters = new HashMap<String, Integer>();
            HashMap<String, Map<Integer, Histogram>> histograms = new HashMap<String, Map<Integer, Histogram>>();
            for (Map.Entry metricEntry : workerMetricMap.entrySet()) {
                MetricInfo metricInfo = (MetricInfo)metricEntry.getValue();
                Map<String, Map<Integer, MetricSnapshot>> metrics = metricInfo.get_metrics();
                for (Map.Entry<String, Map<Integer, MetricSnapshot>> metric : metrics.entrySet()) {
                    String metricName = metric.getKey();
                    Map<Integer, MetricSnapshot> data = metric.getValue();
                    MetaType metaType = MetricUtils.metaType(metricName);
                    MetricType metricType = MetricUtils.metricType(metricName);
                    if (metricType == MetricType.COUNTER) {
                        this.mergeCounters(tpMetric, metaType, metricName, data);
                        continue;
                    }
                    if (metricType == MetricType.GAUGE) {
                        this.mergeGauges(tpMetric, metaType, metricName, data);
                        continue;
                    }
                    if (metricType == MetricType.METER) {
                        this.mergeMeters(this.getMetricInfoByType(tpMetric, metaType), metricName, data, metricNameCounters);
                        continue;
                    }
                    if (metricType != MetricType.HISTOGRAM) continue;
                    this.mergeHistograms(this.getMetricInfoByType(tpMetric, metaType), metricName, data, metricNameCounters, histograms);
                }
            }
            this.adjustHistogramTimerMetrics(tpMetric, metricNameCounters, histograms);
            this.LOG.info("merge topology metrics:{}, cost:{}", (Object)this.topologyId, (Object)(System.currentTimeMillis() - start));
            TopologyMetric topologyMetric = tpMetric;
            return topologyMetric;
        }
        finally {
            this.setMerging(false);
        }
    }

    protected MetricInfo getMetricInfoByType(TopologyMetric topologyMetric, MetaType type) {
        if (type == MetaType.TASK) {
            return topologyMetric.get_taskMetric();
        }
        if (type == MetaType.WORKER) {
            return topologyMetric.get_workerMetric();
        }
        if (type == MetaType.COMPONENT) {
            return topologyMetric.get_componentMetric();
        }
        if (type == MetaType.STREAM) {
            return topologyMetric.get_streamMetric();
        }
        if (type == MetaType.NETTY) {
            return topologyMetric.get_nettyMetric();
        }
        if (type == MetaType.TOPOLOGY) {
            return topologyMetric.get_topologyMetric();
        }
        return null;
    }

    public void mergeCounters(TopologyMetric tpMetric, MetaType metaType, String meta, Map<Integer, MetricSnapshot> data) {
        MetricInfo metricInfo = this.getMetricInfoByType(tpMetric, metaType);
        Map<Integer, MetricSnapshot> existing = metricInfo.get_metrics().get(meta);
        if (existing == null) {
            metricInfo.put_to_metrics(meta, data);
        } else {
            for (Map.Entry<Integer, MetricSnapshot> dataEntry : data.entrySet()) {
                Integer win = dataEntry.getKey();
                MetricSnapshot snapshot = dataEntry.getValue();
                MetricSnapshot old = existing.get(win);
                if (old == null) {
                    existing.put(win, snapshot);
                    continue;
                }
                old.set_ts(snapshot.get_ts());
                old.set_longValue(old.get_longValue() + snapshot.get_longValue());
            }
        }
    }

    public void mergeGauges(TopologyMetric tpMetric, MetaType metaType, String meta, Map<Integer, MetricSnapshot> data) {
        MetricInfo metricInfo = this.getMetricInfoByType(tpMetric, metaType);
        Map<Integer, MetricSnapshot> existing = metricInfo.get_metrics().get(meta);
        if (existing == null) {
            metricInfo.put_to_metrics(meta, data);
        } else {
            for (Map.Entry<Integer, MetricSnapshot> dataEntry : data.entrySet()) {
                Integer win = dataEntry.getKey();
                MetricSnapshot snapshot = dataEntry.getValue();
                MetricSnapshot old = existing.get(win);
                if (old == null) {
                    existing.put(win, snapshot);
                    continue;
                }
                if (snapshot.get_ts() < old.get_ts()) continue;
                old.set_ts(snapshot.get_ts());
                if (metaType != MetaType.TOPOLOGY) {
                    old.set_doubleValue(snapshot.get_doubleValue());
                    continue;
                }
                old.set_doubleValue(old.get_doubleValue() + snapshot.get_doubleValue());
            }
        }
    }

    public void mergeMeters(MetricInfo metricInfo, String meta, Map<Integer, MetricSnapshot> data, Map<String, Integer> metaCounters) {
        Map<Integer, MetricSnapshot> existing = metricInfo.get_metrics().get(meta);
        if (existing == null) {
            metricInfo.put_to_metrics(meta, data);
        } else {
            for (Map.Entry<Integer, MetricSnapshot> dataEntry : data.entrySet()) {
                Integer win = dataEntry.getKey();
                MetricSnapshot snapshot = dataEntry.getValue();
                MetricSnapshot old = existing.get(win);
                if (old == null) {
                    existing.put(win, snapshot);
                    continue;
                }
                if (snapshot.get_ts() < old.get_ts()) continue;
                old.set_ts(snapshot.get_ts());
                old.set_mean(old.get_mean() + snapshot.get_mean());
                old.set_m1(old.get_m1() + snapshot.get_m1());
                old.set_m5(old.get_m5() + snapshot.get_m5());
                old.set_m15(old.get_m15() + snapshot.get_m15());
            }
        }
        this.updateMetricCounters(meta, metaCounters);
    }

    public void mergeHistograms(MetricInfo metricInfo, String meta, Map<Integer, MetricSnapshot> data, Map<String, Integer> metaCounters, Map<String, Map<Integer, Histogram>> histograms) {
        Map<Integer, MetricSnapshot> existing = metricInfo.get_metrics().get(meta);
        if (existing == null) {
            metricInfo.put_to_metrics(meta, data);
            HashMap<Integer, Histogram> histogramMap = new HashMap<Integer, Histogram>();
            for (Map.Entry<Integer, MetricSnapshot> dataEntry : data.entrySet()) {
                Histogram histogram = MetricUtils.metricSnapshot2Histogram(dataEntry.getValue());
                histogramMap.put(dataEntry.getKey(), histogram);
            }
            histograms.put(meta, histogramMap);
        } else {
            for (Map.Entry<Integer, MetricSnapshot> dataEntry : data.entrySet()) {
                Integer win = dataEntry.getKey();
                MetricSnapshot snapshot = dataEntry.getValue();
                MetricSnapshot old = existing.get(win);
                if (old == null) {
                    existing.put(win, snapshot);
                    histograms.get(meta).put(win, MetricUtils.metricSnapshot2Histogram(snapshot));
                    continue;
                }
                if (snapshot.get_ts() < old.get_ts()) continue;
                old.set_ts(snapshot.get_ts());
                MetricUtils.updateHistogramPoints(histograms.get(meta).get(win), snapshot.get_points(), snapshot.get_pointSize());
            }
        }
        this.updateMetricCounters(meta, metaCounters);
    }

    protected void updateMetricCounters(String metricName, Map<String, Integer> metricNameCounters) {
        if (metricNameCounters.containsKey(metricName)) {
            metricNameCounters.put(metricName, metricNameCounters.get(metricName) + 1);
        } else {
            metricNameCounters.put(metricName, 1);
        }
    }

    protected void adjustHistogramTimerMetrics(TopologyMetric tpMetric, Map<String, Integer> metaCounters, Map<String, Map<Integer, Histogram>> histograms) {
        this.resetPoints(tpMetric.get_taskMetric().get_metrics());
        this.resetPoints(tpMetric.get_streamMetric().get_metrics());
        this.resetPoints(tpMetric.get_nettyMetric().get_metrics());
        this.resetPoints(tpMetric.get_workerMetric().get_metrics());
        Map<String, Map<Integer, MetricSnapshot>> compMetrics = tpMetric.get_componentMetric().get_metrics();
        Map<String, Map<Integer, MetricSnapshot>> topologyMetrics = tpMetric.get_topologyMetric().get_metrics();
        this.adjustMetrics(compMetrics, metaCounters, histograms);
        this.adjustMetrics(topologyMetrics, metaCounters, histograms);
    }

    private void adjustMetrics(Map<String, Map<Integer, MetricSnapshot>> metrics, Map<String, Integer> metaCounters, Map<String, Map<Integer, Histogram>> histograms) {
        for (Map.Entry<String, Map<Integer, MetricSnapshot>> metricEntry : metrics.entrySet()) {
            String meta = metricEntry.getKey();
            MetricType metricType = MetricUtils.metricType(meta);
            MetaType metaType = MetricUtils.metaType(meta);
            Map<Integer, MetricSnapshot> winData = metricEntry.getValue();
            if (metricType != MetricType.HISTOGRAM) continue;
            for (Map.Entry<Integer, MetricSnapshot> dataEntry : winData.entrySet()) {
                MetricSnapshot snapshot = dataEntry.getValue();
                Integer cnt = metaCounters.get(meta);
                Histogram histogram = histograms.get(meta).get(dataEntry.getKey());
                if (cnt != null && cnt > 1) {
                    Snapshot snapshot1 = histogram.getSnapshot();
                    snapshot.set_mean(snapshot1.getMean());
                    snapshot.set_p50(snapshot1.getMedian());
                    snapshot.set_p75(snapshot1.get75thPercentile());
                    snapshot.set_p95(snapshot1.get95thPercentile());
                    snapshot.set_p98(snapshot1.get98thPercentile());
                    snapshot.set_p99(snapshot1.get99thPercentile());
                    snapshot.set_p999(snapshot1.get999thPercentile());
                    snapshot.set_stddev(snapshot1.getStdDev());
                    snapshot.set_min(snapshot1.getMin());
                    snapshot.set_max(snapshot1.getMax());
                    if (metaType == MetaType.TOPOLOGY) {
                        snapshot.set_points(MetricUtils.longs2bytes(snapshot1.getValues()));
                    }
                }
                if (metaType == MetaType.TOPOLOGY) continue;
                snapshot.set_points(new byte[0]);
            }
        }
    }

    private void resetPoints(Map<String, Map<Integer, MetricSnapshot>> metrics) {
        for (Map.Entry<String, Map<Integer, MetricSnapshot>> metricEntry : metrics.entrySet()) {
            String meta = metricEntry.getKey();
            MetricType metricType = MetricUtils.metricType(meta);
            Map<Integer, MetricSnapshot> winData = metricEntry.getValue();
            if (metricType != MetricType.HISTOGRAM) continue;
            for (MetricSnapshot snapshot : winData.values()) {
                snapshot.set_points(new byte[0]);
            }
        }
    }

    protected void adjustCounterMetrics(TopologyMetric tpMetric, TopologyMetric oldMetric) {
        if (oldMetric != null) {
            this.mergeCounters(tpMetric.get_streamMetric().get_metrics(), oldMetric.get_streamMetric().get_metrics());
            this.mergeCounters(tpMetric.get_taskMetric().get_metrics(), oldMetric.get_taskMetric().get_metrics());
            this.mergeCounters(tpMetric.get_componentMetric().get_metrics(), oldMetric.get_componentMetric().get_metrics());
            this.mergeCounters(tpMetric.get_workerMetric().get_metrics(), oldMetric.get_workerMetric().get_metrics());
            this.mergeCounters(tpMetric.get_nettyMetric().get_metrics(), oldMetric.get_nettyMetric().get_metrics());
        }
    }

    private void mergeCounters(Map<String, Map<Integer, MetricSnapshot>> newCounters, Map<String, Map<Integer, MetricSnapshot>> oldCounters) {
        for (Map.Entry<String, Map<Integer, MetricSnapshot>> entry : newCounters.entrySet()) {
            String metricName = entry.getKey();
            Map<Integer, MetricSnapshot> snapshots = entry.getValue();
            Map<Integer, MetricSnapshot> oldSnapshots = oldCounters.get(metricName);
            if (oldSnapshots == null || oldSnapshots.size() <= 0) continue;
            for (Map.Entry<Integer, MetricSnapshot> snapshotEntry : snapshots.entrySet()) {
                Integer win = snapshotEntry.getKey();
                MetricSnapshot snapshot = snapshotEntry.getValue();
                MetricSnapshot oldSnapshot = oldSnapshots.get(win);
                if (oldSnapshot == null) continue;
                snapshot.set_longValue(snapshot.get_longValue() + oldSnapshot.get_longValue());
            }
        }
    }

    private double getSampleRate() {
        return ConfigExtension.getMetricSampleRate(this.conf);
    }
}

