/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.schedule;

import com.alibaba.jstorm.schedule.default_assign.ResourceWorkerSlot;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Assignment
implements Serializable {
    private static final long serialVersionUID = 6087667851333314069L;
    private final String masterCodeDir;
    private final Map<String, String> nodeHost;
    private final Map<Integer, Integer> taskStartTimeSecs;
    private final Set<ResourceWorkerSlot> workers;
    private long timeStamp;
    private AssignmentType type;

    public Assignment() {
        this.masterCodeDir = null;
        this.nodeHost = new HashMap<String, String>();
        this.taskStartTimeSecs = new HashMap<Integer, Integer>();
        this.workers = new HashSet<ResourceWorkerSlot>();
        this.timeStamp = System.currentTimeMillis();
        this.type = AssignmentType.Assign;
    }

    public Assignment(String masterCodeDir, Set<ResourceWorkerSlot> workers, Map<String, String> nodeHost, Map<Integer, Integer> taskStartTimeSecs) {
        this.workers = workers;
        this.nodeHost = nodeHost;
        this.taskStartTimeSecs = taskStartTimeSecs;
        this.masterCodeDir = masterCodeDir;
        this.timeStamp = System.currentTimeMillis();
        this.type = AssignmentType.Assign;
    }

    public void setAssignmentType(AssignmentType type) {
        this.type = type;
    }

    public AssignmentType getAssignmentType() {
        return this.type;
    }

    public Map<String, String> getNodeHost() {
        return this.nodeHost;
    }

    public Map<Integer, Integer> getTaskStartTimeSecs() {
        return this.taskStartTimeSecs;
    }

    public String getMasterCodeDir() {
        return this.masterCodeDir;
    }

    public Set<ResourceWorkerSlot> getWorkers() {
        return this.workers;
    }

    public Map<Integer, ResourceWorkerSlot> getTaskToNodePortbyNode(String supervisorId) {
        HashMap<Integer, ResourceWorkerSlot> result2 = new HashMap<Integer, ResourceWorkerSlot>();
        for (ResourceWorkerSlot worker : this.workers) {
            if (!worker.getNodeId().equals(supervisorId)) continue;
            result2.put(worker.getPort(), worker);
        }
        return result2;
    }

    public Set<Integer> getCurrentSuperviosrTasks(String supervisorId) {
        HashSet<Integer> Tasks = new HashSet<Integer>();
        for (ResourceWorkerSlot worker : this.workers) {
            if (!worker.getNodeId().equals(supervisorId)) continue;
            Tasks.addAll(worker.getTasks());
        }
        return Tasks;
    }

    public Set<Integer> getCurrentSuperviosrWorkers(String supervisorId) {
        HashSet<Integer> workerSet = new HashSet<Integer>();
        for (ResourceWorkerSlot worker : this.workers) {
            if (!worker.getNodeId().equals(supervisorId)) continue;
            workerSet.add(worker.getPort());
        }
        return workerSet;
    }

    public Set<Integer> getCurrentWorkerTasks(String supervisorId, int port) {
        for (ResourceWorkerSlot worker : this.workers) {
            if (!worker.getNodeId().equals(supervisorId) || worker.getPort() != port) continue;
            return worker.getTasks();
        }
        return new HashSet<Integer>();
    }

    public ResourceWorkerSlot getWorkerByTaskId(Integer taskId) {
        for (ResourceWorkerSlot worker : this.workers) {
            if (!worker.getTasks().contains(taskId)) continue;
            return worker;
        }
        return null;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isTopologyChange(long oldTimeStamp) {
        boolean isChange = false;
        if (this.timeStamp > oldTimeStamp && (this.type.equals((Object)AssignmentType.UpdateTopology) || this.type.equals((Object)AssignmentType.ScaleTopology))) {
            isChange = true;
        }
        return isChange;
    }

    public void updateTimeStamp() {
        this.timeStamp = System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.masterCodeDir == null ? 0 : this.masterCodeDir.hashCode());
        result2 = 31 * result2 + (this.nodeHost == null ? 0 : this.nodeHost.hashCode());
        result2 = 31 * result2 + (this.taskStartTimeSecs == null ? 0 : this.taskStartTimeSecs.hashCode());
        result2 = 31 * result2 + (this.workers == null ? 0 : this.workers.hashCode());
        result2 = 31 * result2 + (int)(this.timeStamp & 0xFFFFFFFFFFFFFFFFL);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Assignment other = (Assignment)obj;
        if (this.masterCodeDir == null ? other.masterCodeDir != null : !this.masterCodeDir.equals(other.masterCodeDir)) {
            return false;
        }
        if (this.nodeHost == null ? other.nodeHost != null : !this.nodeHost.equals(other.nodeHost)) {
            return false;
        }
        if (this.taskStartTimeSecs == null ? other.taskStartTimeSecs != null : !this.taskStartTimeSecs.equals(other.taskStartTimeSecs)) {
            return false;
        }
        if (this.workers == null ? other.workers != null : !this.workers.equals(other.workers)) {
            return false;
        }
        return this.timeStamp == other.timeStamp;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static enum AssignmentType {
        Assign,
        UpdateTopology,
        ScaleTopology;

    }
}

