/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.schedule;

import com.alibaba.jstorm.utils.OlderFileFilter;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(CleanRunnable.class);
    private String dir_location;
    private int seconds;

    public CleanRunnable(String dir_location, int inbox_jar_expiration_secs) {
        this.dir_location = dir_location;
        this.seconds = inbox_jar_expiration_secs;
    }

    @Override
    public void run() {
        File inboxdir = new File(this.dir_location);
        this.clean(inboxdir);
    }

    private void clean(File file) {
        File[] files;
        OlderFileFilter filter = new OlderFileFilter(this.seconds);
        for (File f : files = file.listFiles(filter)) {
            if (f.isFile()) {
                log.info("Cleaning inbox ... deleted: " + f.getName());
                try {
                    f.delete();
                }
                catch (Exception e) {
                    log.error("Cleaning inbox ... error deleting:" + f.getName() + "," + e);
                }
                continue;
            }
            this.clean(f);
            if (f.listFiles().length != 0) continue;
            log.info("Cleaning inbox ... deleted: " + f.getName());
            try {
                f.delete();
            }
            catch (Exception e) {
                log.error("Cleaning inbox ... error deleting:" + f.getName() + "," + e);
            }
        }
    }
}

