/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.schedule.default_assign;

import backtype.storm.generated.Bolt;
import backtype.storm.generated.ComponentCommon;
import backtype.storm.generated.SpoutSpec;
import backtype.storm.generated.StateSpoutSpec;
import backtype.storm.generated.StormTopology;
import backtype.storm.utils.ThriftTopologyUtils;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.cluster.Common;
import com.alibaba.jstorm.daemon.supervisor.SupervisorInfo;
import com.alibaba.jstorm.schedule.TopologyAssignContext;
import com.alibaba.jstorm.schedule.default_assign.ResourceWorkerSlot;
import com.alibaba.jstorm.utils.FailedAssignTopologyException;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class DefaultTopologyAssignContext
extends TopologyAssignContext {
    private final StormTopology sysTopology;
    private final Map<String, String> sidToHostname;
    private final Map<String, List<String>> hostToSid;
    private final Set<ResourceWorkerSlot> oldWorkers;
    private final Map<String, List<Integer>> componentTasks;
    private final Set<ResourceWorkerSlot> unstoppedWorkers = new HashSet<ResourceWorkerSlot>();
    private final int totalWorkerNum;
    private final int unstoppedWorkerNum;

    private int computeWorkerNum() {
        Integer settingNum = JStormUtils.parseInt(this.stormConf.get("topology.workers"));
        int ret = 0;
        int hintSum = 0;
        int tmCount = 0;
        Map<String, Object> components = ThriftTopologyUtils.getComponents(this.sysTopology);
        for (Map.Entry<String, Object> entry : components.entrySet()) {
            String componentName = entry.getKey();
            Object component = entry.getValue();
            ComponentCommon common = null;
            if (component instanceof Bolt) {
                common = ((Bolt)component).get_common();
            }
            if (component instanceof SpoutSpec) {
                common = ((SpoutSpec)component).get_common();
            }
            if (component instanceof StateSpoutSpec) {
                common = ((StateSpoutSpec)component).get_common();
            }
            int hint = common.get_parallelism_hint();
            if (componentName.equals("__topology_master")) {
                tmCount += hint;
                continue;
            }
            hintSum += hint;
        }
        ret = settingNum == null ? hintSum : Math.min(settingNum, hintSum);
        Boolean isTmSingleWorker = ConfigExtension.getTopologyMasterSingleWorker(this.stormConf);
        if (isTmSingleWorker != null) {
            if (isTmSingleWorker.booleanValue()) {
                ret += tmCount;
                this.setAssignSingleWorkerForTM(true);
            }
        } else if (ret >= 10) {
            ret += tmCount;
            this.setAssignSingleWorkerForTM(true);
        }
        return ret;
    }

    public int computeUnstoppedAssignments() {
        for (Integer task : this.unstoppedTaskIds) {
            ResourceWorkerSlot worker = this.oldAssignment.getWorkerByTaskId(task);
            this.unstoppedWorkers.add(worker);
        }
        return this.unstoppedWorkers.size();
    }

    private void refineDeadTasks() {
        Set<Integer> rawDeadTasks = this.getDeadTaskIds();
        HashSet<Integer> refineDeadTasks = new HashSet<Integer>();
        refineDeadTasks.addAll(rawDeadTasks);
        Set<Integer> unstoppedTasks = this.getUnstoppedTaskIds();
        for (Integer task : rawDeadTasks) {
            if (unstoppedTasks.contains(task)) continue;
            for (ResourceWorkerSlot worker : this.oldWorkers) {
                if (!worker.getTasks().contains(task)) continue;
                refineDeadTasks.addAll(worker.getTasks());
            }
        }
        this.setDeadTaskIds(refineDeadTasks);
    }

    private Map<String, String> generateSidToHost() {
        HashMap<String, String> sidToHostname = new HashMap<String, String>();
        if (this.oldAssignment != null) {
            sidToHostname.putAll(this.oldAssignment.getNodeHost());
        }
        for (Map.Entry entry : this.cluster.entrySet()) {
            String supervisorId = (String)entry.getKey();
            SupervisorInfo supervisorInfo = (SupervisorInfo)entry.getValue();
            sidToHostname.put(supervisorId, supervisorInfo.getHostName());
        }
        return sidToHostname;
    }

    public DefaultTopologyAssignContext(TopologyAssignContext context) {
        super(context);
        try {
            this.sysTopology = Common.system_topology(this.stormConf, this.rawTopology);
        }
        catch (Exception e) {
            throw new FailedAssignTopologyException("Failed to generate system topology");
        }
        this.sidToHostname = this.generateSidToHost();
        this.hostToSid = JStormUtils.reverse_map(this.sidToHostname);
        this.oldWorkers = this.oldAssignment != null && this.oldAssignment.getWorkers() != null ? this.oldAssignment.getWorkers() : new HashSet<ResourceWorkerSlot>();
        this.refineDeadTasks();
        this.componentTasks = JStormUtils.reverse_map(context.getTaskToComponent());
        for (Map.Entry<String, List<Integer>> entry : this.componentTasks.entrySet()) {
            List<Integer> componentTaskList = entry.getValue();
            Collections.sort(componentTaskList);
        }
        this.totalWorkerNum = this.computeWorkerNum();
        this.unstoppedWorkerNum = this.computeUnstoppedAssignments();
    }

    public StormTopology getSysTopology() {
        return this.sysTopology;
    }

    public Map<String, String> getSidToHostname() {
        return this.sidToHostname;
    }

    public Map<String, List<String>> getHostToSid() {
        return this.hostToSid;
    }

    public Map<String, List<Integer>> getComponentTasks() {
        return this.componentTasks;
    }

    public int getTotalWorkerNum() {
        return this.totalWorkerNum;
    }

    public int getUnstoppedWorkerNum() {
        return this.unstoppedWorkerNum;
    }

    public Set<ResourceWorkerSlot> getOldWorkers() {
        return this.oldWorkers;
    }

    @Override
    public Set<ResourceWorkerSlot> getUnstoppedWorkers() {
        return this.unstoppedWorkers;
    }

    @Override
    public String toString() {
        return (String)this.stormConf.get("topology.name");
    }

    public String toDetailString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

