/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.schedule.default_assign;

import backtype.storm.scheduler.WorkerSlot;
import com.alibaba.jstorm.client.WorkerAssignment;
import com.alibaba.jstorm.utils.NetWorkUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceWorkerSlot
extends WorkerSlot
implements Serializable {
    public static Logger LOG = LoggerFactory.getLogger(ResourceWorkerSlot.class);
    private static final long serialVersionUID = 9138386287559932411L;
    private String hostname;
    private long memSize;
    private int cpu;
    private Set<Integer> tasks;
    private String jvm;

    public ResourceWorkerSlot() {
    }

    public ResourceWorkerSlot(String supervisorId, Integer port) {
        super(supervisorId, port);
    }

    public ResourceWorkerSlot(WorkerAssignment worker, Map<String, List<Integer>> componentToTask) {
        super(worker.getNodeId(), worker.getPort());
        this.hostname = worker.getHostName();
        this.tasks = new HashSet<Integer>();
        this.cpu = worker.getCpu();
        this.memSize = worker.getMem();
        this.jvm = worker.getJvm();
        for (Map.Entry<String, Integer> entry : worker.getComponentToNum().entrySet()) {
            List<Integer> tasks = componentToTask.get(entry.getKey());
            if (tasks == null || tasks.size() == 0) continue;
            int num = Math.min(tasks.size(), entry.getValue());
            ArrayList<Integer> cTasks = new ArrayList<Integer>();
            cTasks.addAll(tasks.subList(0, num));
            this.tasks.addAll(cTasks);
            tasks.removeAll(cTasks);
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Set<Integer> getTasks() {
        return this.tasks;
    }

    public void setTasks(Set<Integer> tasks) {
        this.tasks = tasks;
    }

    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public long getMemSize() {
        return this.memSize;
    }

    public void setMemSize(long memSize) {
        this.memSize = memSize;
    }

    public int getCpu() {
        return this.cpu;
    }

    public void setCpu(int cpu) {
        this.cpu = cpu;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean compareToUserDefineWorker(WorkerAssignment worker, Map<Integer, String> taskToComponent) {
        int cpu = worker.getCpu();
        if (cpu != 0 && this.cpu != cpu) {
            return false;
        }
        long mem = worker.getMem();
        if (mem != 0L && this.memSize != mem) {
            return false;
        }
        String jvm = worker.getJvm();
        if (jvm != null && !jvm.equals(this.jvm)) {
            return false;
        }
        String hostName = worker.getHostName();
        if (!NetWorkUtils.equals(this.hostname, hostName)) {
            return false;
        }
        int port = worker.getPort();
        if (port != 0 && port != this.getPort()) {
            return false;
        }
        Map<String, Integer> componentToNum = worker.getComponentToNum();
        HashMap<String, Integer> myComponentToNum = new HashMap<String, Integer>();
        for (Integer task : this.tasks) {
            String component = taskToComponent.get(task);
            Integer i = (Integer)myComponentToNum.get(component);
            if (i == null) {
                i = 0;
            }
            i = i + 1;
            myComponentToNum.put(component, i);
        }
        return myComponentToNum.equals(componentToNum);
    }

    public String getHostPort() {
        return this.hostname + ":" + this.getPort();
    }
}

