/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.schedule.default_assign;

import com.alibaba.jstorm.schedule.default_assign.ResourceWorkerSlot;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskAssignContext {
    private final Map<Integer, String> taskToComponent;
    private final Map<String, List<ResourceWorkerSlot>> supervisorToWorker;
    private final Map<String, Set<String>> relationship;
    private final Map<ResourceWorkerSlot, Map<String, Integer>> workerToComponentNum = new HashMap<ResourceWorkerSlot, Map<String, Integer>>();
    private final Map<ResourceWorkerSlot, Integer> workerToTaskNum = new HashMap<ResourceWorkerSlot, Integer>();
    private final Map<String, ResourceWorkerSlot> HostPortToWorkerMap = new HashMap<String, ResourceWorkerSlot>();

    public TaskAssignContext(Map<String, List<ResourceWorkerSlot>> supervisorToWorker, Map<String, Set<String>> relationship, Map<Integer, String> taskToComponent) {
        this.taskToComponent = taskToComponent;
        this.supervisorToWorker = supervisorToWorker;
        this.relationship = relationship;
        for (Map.Entry<String, List<ResourceWorkerSlot>> entry : supervisorToWorker.entrySet()) {
            for (ResourceWorkerSlot worker : entry.getValue()) {
                this.workerToTaskNum.put(worker, worker.getTasks() != null ? worker.getTasks().size() : 0);
                this.HostPortToWorkerMap.put(worker.getHostPort(), worker);
                if (worker.getTasks() == null) continue;
                HashMap<String, Integer> componentToNum = new HashMap<String, Integer>();
                for (Integer taskId : worker.getTasks()) {
                    String componentId = taskToComponent.get(taskId);
                    int num = componentToNum.get(componentId) == null ? 0 : (Integer)componentToNum.get(componentId);
                    componentToNum.put(componentId, ++num);
                }
                this.workerToComponentNum.put(worker, componentToNum);
            }
        }
    }

    public Map<ResourceWorkerSlot, Integer> getWorkerToTaskNum() {
        return this.workerToTaskNum;
    }

    public Map<String, List<ResourceWorkerSlot>> getSupervisorToWorker() {
        return this.supervisorToWorker;
    }

    public Map<ResourceWorkerSlot, Map<String, Integer>> getWorkerToComponentNum() {
        return this.workerToComponentNum;
    }

    public Map<String, Set<String>> getRelationship() {
        return this.relationship;
    }

    public int getComponentNumOnSupervisor(String supervisor, String name) {
        List<ResourceWorkerSlot> workers = this.supervisorToWorker.get(supervisor);
        if (workers == null) {
            return 0;
        }
        int result2 = 0;
        for (ResourceWorkerSlot worker : workers) {
            result2 += this.getComponentNumOnWorker(worker, name);
        }
        return result2;
    }

    public int getComponentNumOnWorker(ResourceWorkerSlot worker, String name) {
        int result2 = 0;
        Map<String, Integer> componentNum = this.workerToComponentNum.get(worker);
        if (componentNum != null && componentNum.get(name) != null) {
            result2 = componentNum.get(name);
        }
        return result2;
    }

    public int getTaskNumOnSupervisor(String supervisor) {
        List<ResourceWorkerSlot> workers = this.supervisorToWorker.get(supervisor);
        if (workers == null) {
            return 0;
        }
        int result2 = 0;
        for (ResourceWorkerSlot worker : workers) {
            result2 += this.getTaskNumOnWorker(worker);
        }
        return result2;
    }

    public int getTaskNumOnWorker(ResourceWorkerSlot worker) {
        return worker.getTasks() == null ? 0 : worker.getTasks().size();
    }

    public int getInputComponentNumOnSupervisor(String supervisor, String name) {
        int result2 = 0;
        List<ResourceWorkerSlot> workers = this.supervisorToWorker.get(supervisor);
        if (workers == null) {
            return 0;
        }
        for (ResourceWorkerSlot worker : workers) {
            result2 += this.getInputComponentNumOnWorker(worker, name);
        }
        return result2;
    }

    public int getInputComponentNumOnWorker(ResourceWorkerSlot worker, String name) {
        int result2 = 0;
        for (String component : this.relationship.get(name)) {
            result2 += this.getComponentNumOnWorker(worker, component);
        }
        return result2;
    }

    public Map<String, ResourceWorkerSlot> getHostPortToWorkerMap() {
        return this.HostPortToWorkerMap;
    }

    public ResourceWorkerSlot getWorker(ResourceWorkerSlot worker) {
        return this.HostPortToWorkerMap.get(worker.getHostPort());
    }
}

