/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.schedule.default_assign;

import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.cluster.Common;
import com.alibaba.jstorm.schedule.default_assign.DefaultTopologyAssignContext;
import com.alibaba.jstorm.schedule.default_assign.ResourceWorkerSlot;
import com.alibaba.jstorm.schedule.default_assign.Selector.ComponentNumSelector;
import com.alibaba.jstorm.schedule.default_assign.Selector.InputComponentNumSelector;
import com.alibaba.jstorm.schedule.default_assign.Selector.Selector;
import com.alibaba.jstorm.schedule.default_assign.Selector.TotalTaskNumSelector;
import com.alibaba.jstorm.schedule.default_assign.TaskAssignContext;
import com.alibaba.jstorm.utils.FailedAssignTopologyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskScheduler {
    public static Logger LOG = LoggerFactory.getLogger(TaskScheduler.class);
    private final TaskAssignContext taskContext;
    private List<ResourceWorkerSlot> assignments = new ArrayList<ResourceWorkerSlot>();
    private int workerNum;
    private int avgTaskNum;
    private int leftTaskNum;
    private Set<Integer> tasks;
    private DefaultTopologyAssignContext context;
    private Selector componentSelector;
    private Selector inputComponentSelector;
    private Selector totalTaskNumSelector;

    public TaskScheduler(DefaultTopologyAssignContext context, Set<Integer> tasks, List<ResourceWorkerSlot> workers) {
        this.tasks = tasks;
        LOG.info("Tasks " + tasks + " is going to be assigned in workers " + workers);
        this.context = context;
        this.taskContext = new TaskAssignContext(this.buildSupervisorToWorker(workers), Common.buildSpoutOutoputAndBoltInputMap(context), context.getTaskToComponent());
        this.componentSelector = new ComponentNumSelector(this.taskContext);
        this.inputComponentSelector = new InputComponentNumSelector(this.taskContext);
        this.totalTaskNumSelector = new TotalTaskNumSelector(this.taskContext);
        if (tasks.size() == 0) {
            return;
        }
        if ((context.getAssignType() != 1 || context.isReassign()) && context.getAssignSingleWorkerForTM() && tasks.contains(context.getTopologyMasterTaskId())) {
            this.assignForTopologyMaster();
        }
        int taskNum = tasks.size();
        Map<ResourceWorkerSlot, Integer> workerSlotIntegerMap = this.taskContext.getWorkerToTaskNum();
        HashSet preAssignWorkers = new HashSet();
        for (Map.Entry<ResourceWorkerSlot, Integer> worker : workerSlotIntegerMap.entrySet()) {
            if (worker.getValue() <= 0) continue;
            taskNum += worker.getValue().intValue();
            preAssignWorkers.add(worker.getKey());
        }
        this.setTaskNum(taskNum, this.workerNum);
        for (Map.Entry<ResourceWorkerSlot, Integer> worker : preAssignWorkers) {
            Set<ResourceWorkerSlot> doneWorkers;
            if (!this.taskContext.getWorkerToTaskNum().keySet().contains(worker) || (doneWorkers = this.removeWorkerFromSrcPool(this.taskContext.getWorkerToTaskNum().get(worker), (ResourceWorkerSlot)((Object)worker))) == null) continue;
            for (ResourceWorkerSlot doneWorker : doneWorkers) {
                taskNum -= doneWorker.getTasks().size();
                --this.workerNum;
            }
        }
        this.setTaskNum(taskNum, this.workerNum);
        if (context.getAssignType() == 1 && !context.isReassign()) {
            this.keepAssignment(taskNum, context.getOldAssignment().getWorkers());
        }
    }

    private void keepAssignment(int taskNum, Set<ResourceWorkerSlot> keepAssignments) {
        HashSet<Integer> keepTasks = new HashSet<Integer>();
        ResourceWorkerSlot tmWorker = null;
        for (ResourceWorkerSlot worker : keepAssignments) {
            if (worker.getTasks().contains(this.context.getTopologyMasterTaskId())) {
                tmWorker = worker;
            }
            for (Integer taskId : worker.getTasks()) {
                ResourceWorkerSlot contextWorker;
                if (!this.tasks.contains(taskId) || (contextWorker = this.taskContext.getWorker(worker)) == null) continue;
                if (tmWorker != null && tmWorker.getTasks().contains(taskId) && this.context.getAssignSingleWorkerForTM()) {
                    if (this.context.getTopologyMasterTaskId() != taskId.intValue()) continue;
                    this.updateAssignedTasksOfWorker(taskId, contextWorker);
                    this.taskContext.getWorkerToTaskNum().remove(contextWorker);
                    contextWorker.getTasks().clear();
                    contextWorker.getTasks().add(taskId);
                    this.assignments.add(contextWorker);
                    this.tasks.remove(taskId);
                    --taskNum;
                    --this.workerNum;
                    LOG.info("assignForTopologyMaster: " + contextWorker);
                    continue;
                }
                String componentName = this.context.getTaskToComponent().get(taskId);
                this.updateAssignedTasksOfWorker(taskId, contextWorker);
                this.updateComponentsNumOfWorker(componentName, contextWorker);
                keepTasks.add(taskId);
            }
        }
        if (tmWorker != null) {
            this.setTaskNum(taskNum, this.workerNum);
            keepAssignments.remove(tmWorker);
        }
        int doneAssignedTaskNum = 0;
        while (true) {
            boolean found = false;
            HashSet<ResourceWorkerSlot> doneAssignedWorkers = new HashSet<ResourceWorkerSlot>();
            for (ResourceWorkerSlot worker : keepAssignments) {
                ResourceWorkerSlot contextWorker = this.taskContext.getWorker(worker);
                if (contextWorker == null || !this.isTaskFullForWorker(contextWorker)) continue;
                found = true;
                --this.workerNum;
                this.taskContext.getWorkerToTaskNum().remove(contextWorker);
                this.assignments.add(contextWorker);
                doneAssignedWorkers.add(worker);
                doneAssignedTaskNum += contextWorker.getTasks().size();
            }
            if (!found) break;
            this.setTaskNum(taskNum -= doneAssignedTaskNum, this.workerNum);
            keepAssignments.removeAll(doneAssignedWorkers);
        }
        this.tasks.removeAll(keepTasks);
        LOG.info("keep following assignment, " + this.assignments);
    }

    private boolean isTaskFullForWorker(ResourceWorkerSlot worker) {
        boolean ret = false;
        Set<Integer> tasks = worker.getTasks();
        if (tasks != null && (this.leftTaskNum <= 0 && tasks.size() >= this.avgTaskNum || this.leftTaskNum > 0 && tasks.size() >= this.avgTaskNum + 1)) {
            ret = true;
        }
        return ret;
    }

    private Set<ResourceWorkerSlot> getRestAssignedWorkers() {
        HashSet<ResourceWorkerSlot> ret = new HashSet<ResourceWorkerSlot>();
        for (ResourceWorkerSlot worker : this.taskContext.getWorkerToTaskNum().keySet()) {
            if (worker.getTasks() == null || worker.getTasks().size() <= 0) continue;
            ret.add(worker);
        }
        return ret;
    }

    public List<ResourceWorkerSlot> assign() {
        if (this.tasks.size() == 0) {
            this.assignments.addAll(this.getRestAssignedWorkers());
            return this.assignments;
        }
        Set<Integer> assignedTasks = this.assignForDifferNodeTask();
        this.tasks.removeAll(assignedTasks);
        HashMap<Integer, String> systemTasks = new HashMap<Integer, String>();
        for (Integer n : this.tasks) {
            String name = this.context.getTaskToComponent().get(n);
            if (Common.isSystemComponent(name)) {
                systemTasks.put(n, name);
                continue;
            }
            this.assignForTask(name, n);
        }
        for (Map.Entry entry : systemTasks.entrySet()) {
            this.assignForTask((String)entry.getValue(), (Integer)entry.getKey());
        }
        this.assignments.addAll(this.getRestAssignedWorkers());
        return this.assignments;
    }

    private void assignForTopologyMaster() {
        int taskId = this.context.getTopologyMasterTaskId();
        ResourceWorkerSlot workerAssigned = null;
        int workerNumOfSuperv = 0;
        block0: for (ResourceWorkerSlot workerSlot : this.taskContext.getWorkerToTaskNum().keySet()) {
            List<ResourceWorkerSlot> workers = this.taskContext.getSupervisorToWorker().get(workerSlot.getNodeId());
            if (workers == null || workers.size() <= workerNumOfSuperv) continue;
            for (ResourceWorkerSlot worker : workers) {
                Set<Integer> tasks = worker.getTasks();
                if (tasks != null && tasks.size() != 0) continue;
                workerAssigned = worker;
                workerNumOfSuperv = workers.size();
                continue block0;
            }
        }
        if (workerAssigned == null) {
            throw new FailedAssignTopologyException("there's no enough workers for the assignment of topology master");
        }
        this.updateAssignedTasksOfWorker(taskId, workerAssigned);
        this.taskContext.getWorkerToTaskNum().remove(workerAssigned);
        this.assignments.add(workerAssigned);
        this.tasks.remove(taskId);
        --this.workerNum;
        LOG.info("assignForTopologyMaster, assignments=" + this.assignments);
    }

    private void assignForTask(String name, Integer task) {
        ResourceWorkerSlot worker = this.chooseWorker(name, new ArrayList<ResourceWorkerSlot>(this.taskContext.getWorkerToTaskNum().keySet()));
        this.pushTaskToWorker(task, name, worker);
    }

    private Set<Integer> assignForDifferNodeTask() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (Integer task : this.tasks) {
            Map conf = Common.getComponentMap(this.context, task);
            if (!ConfigExtension.isTaskOnDifferentNode(conf)) continue;
            ret.add(task);
        }
        for (Integer task : ret) {
            String name = this.context.getTaskToComponent().get(task);
            ResourceWorkerSlot worker = this.chooseWorker(name, this.getDifferNodeTaskWokers(name));
            LOG.info("Due to task.on.differ.node, push task-{} to {}:{}", new Object[]{task, worker.getHostname(), worker.getPort()});
            this.pushTaskToWorker(task, name, worker);
        }
        return ret;
    }

    private Map<String, List<ResourceWorkerSlot>> buildSupervisorToWorker(List<ResourceWorkerSlot> workers) {
        HashMap<String, List<ResourceWorkerSlot>> supervisorToWorker = new HashMap<String, List<ResourceWorkerSlot>>();
        for (ResourceWorkerSlot worker : workers) {
            ArrayList<ResourceWorkerSlot> supervisor = (ArrayList<ResourceWorkerSlot>)supervisorToWorker.get(worker.getNodeId());
            if (supervisor == null) {
                supervisor = new ArrayList<ResourceWorkerSlot>();
                supervisorToWorker.put(worker.getNodeId(), supervisor);
            }
            supervisor.add(worker);
        }
        this.workerNum = workers.size();
        return supervisorToWorker;
    }

    private ResourceWorkerSlot chooseWorker(String name, List<ResourceWorkerSlot> workers) {
        List<ResourceWorkerSlot> result2 = this.componentSelector.select(workers, name);
        result2 = this.totalTaskNumSelector.select(result2, name);
        if (Common.isSystemComponent(name)) {
            return result2.iterator().next();
        }
        result2 = this.inputComponentSelector.select(result2, name);
        return result2.iterator().next();
    }

    private void pushTaskToWorker(Integer task, String name, ResourceWorkerSlot worker) {
        LOG.debug("Push task-" + task + " to worker-" + worker.getPort());
        int taskNum = this.updateAssignedTasksOfWorker(task, worker);
        this.removeWorkerFromSrcPool(taskNum, worker);
        this.updateComponentsNumOfWorker(name, worker);
    }

    private int updateAssignedTasksOfWorker(Integer task, ResourceWorkerSlot worker) {
        int ret = 0;
        Set<Integer> tasks = worker.getTasks();
        if (tasks == null) {
            tasks = new HashSet<Integer>();
            worker.setTasks(tasks);
        }
        tasks.add(task);
        ret = this.taskContext.getWorkerToTaskNum().get(worker);
        this.taskContext.getWorkerToTaskNum().put(worker, ++ret);
        return ret;
    }

    private Set<ResourceWorkerSlot> removeWorkerFromSrcPool(int taskNum, ResourceWorkerSlot worker) {
        HashSet<ResourceWorkerSlot> ret = new HashSet<ResourceWorkerSlot>();
        if (this.leftTaskNum <= 0) {
            if (taskNum >= this.avgTaskNum) {
                this.taskContext.getWorkerToTaskNum().remove(worker);
                this.assignments.add(worker);
                ret.add(worker);
            }
        } else {
            if (taskNum > this.avgTaskNum) {
                this.taskContext.getWorkerToTaskNum().remove(worker);
                this.leftTaskNum -= taskNum - this.avgTaskNum;
                this.assignments.add(worker);
                ret.add(worker);
            }
            if (this.leftTaskNum <= 0) {
                ArrayList<ResourceWorkerSlot> needDelete = new ArrayList<ResourceWorkerSlot>();
                for (Map.Entry<ResourceWorkerSlot, Integer> entry : this.taskContext.getWorkerToTaskNum().entrySet()) {
                    if (this.avgTaskNum == 0 || entry.getValue() != this.avgTaskNum) continue;
                    needDelete.add(entry.getKey());
                }
                for (ResourceWorkerSlot workerToDelete : needDelete) {
                    this.taskContext.getWorkerToTaskNum().remove(workerToDelete);
                    this.assignments.add(workerToDelete);
                    ret.add(workerToDelete);
                }
            }
        }
        return ret;
    }

    private void updateComponentsNumOfWorker(String name, ResourceWorkerSlot worker) {
        Integer componentNum;
        Map<String, Integer> components = this.taskContext.getWorkerToComponentNum().get(worker);
        if (components == null) {
            components = new HashMap<String, Integer>();
            this.taskContext.getWorkerToComponentNum().put(worker, components);
        }
        if ((componentNum = components.get(name)) == null) {
            componentNum = 0;
        }
        componentNum = componentNum + 1;
        components.put(name, componentNum);
    }

    private void setTaskNum(int taskNum, int workerNum) {
        if (taskNum >= 0 && workerNum > 0) {
            this.avgTaskNum = taskNum / workerNum;
            this.leftTaskNum = taskNum % workerNum;
            LOG.debug("avgTaskNum=" + this.avgTaskNum + ", leftTaskNum=" + this.leftTaskNum);
        } else {
            LOG.warn("Illegal parameters, taskNum=" + taskNum + ", workerNum=" + workerNum);
        }
    }

    private List<ResourceWorkerSlot> getDifferNodeTaskWokers(String name) {
        ArrayList<ResourceWorkerSlot> workers = new ArrayList<ResourceWorkerSlot>();
        workers.addAll(this.taskContext.getWorkerToTaskNum().keySet());
        for (Map.Entry<String, List<ResourceWorkerSlot>> entry : this.taskContext.getSupervisorToWorker().entrySet()) {
            if (this.taskContext.getComponentNumOnSupervisor(entry.getKey(), name) == 0) continue;
            workers.removeAll((Collection)entry.getValue());
        }
        if (workers.size() == 0) {
            throw new FailedAssignTopologyException("there's no enough supervisor for making component: " + name + " 's tasks on different node");
        }
        return workers;
    }
}

