/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task;

import com.alibaba.jstorm.common.metric.AsmHistogram;
import com.alibaba.jstorm.common.metric.AsmMetric;
import com.alibaba.jstorm.metric.JStormMetrics;
import com.alibaba.jstorm.metric.MetricType;
import com.alibaba.jstorm.metric.MetricUtils;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskBaseMetric
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(JStormMetrics.class);
    private static final long serialVersionUID = -7157987126460293444L;
    private String topologyId;
    private String componentId;
    private int taskId;
    private final ConcurrentMap<String, AsmMetric> metricCache = new ConcurrentHashMap<String, AsmMetric>();

    public TaskBaseMetric(String topologyId, String componentId, int taskId) {
        this.topologyId = topologyId;
        this.componentId = componentId;
        this.taskId = taskId;
        logger.info("init task base metric, tp id:{}, comp id:{}, task id:{}", new Object[]{topologyId, componentId, taskId});
    }

    private AsmMetric findMetric(String streamId, String name, MetricType metricType, boolean mergeTopology) {
        String key = streamId + name;
        AsmMetric existingMetric = (AsmMetric)this.metricCache.get(key);
        if (existingMetric == null) {
            String fullName = MetricUtils.streamMetricName(this.topologyId, this.componentId, this.taskId, streamId, name, metricType);
            existingMetric = JStormMetrics.getStreamMetric(fullName);
            if (existingMetric == null) {
                existingMetric = AsmMetric.Builder.build(metricType);
                JStormMetrics.registerStreamMetric(fullName, existingMetric, mergeTopology);
            }
            this.metricCache.putIfAbsent(key, existingMetric);
        }
        return existingMetric;
    }

    public void update(String streamId, String name, Number value, MetricType metricType, boolean mergeTopology) {
        AsmMetric existingMetric = this.findMetric(streamId, name, metricType, mergeTopology);
        existingMetric.update(value);
    }

    public void updateTime(String streamId, String name, long start, long end, boolean mergeTopology) {
        long elapsed;
        AsmHistogram histogram;
        AsmMetric existingMetric;
        if (start > 0L && (existingMetric = this.findMetric(streamId, name, MetricType.HISTOGRAM, mergeTopology)) instanceof AsmHistogram && (histogram = (AsmHistogram)existingMetric).okToUpdate(end) && (elapsed = (end - start) * 1000L) >= 0L) {
            histogram.update(elapsed);
            histogram.setLastUpdateTime(end);
        }
    }

    public void update(String streamId, String name, Number value, MetricType metricType) {
        this.update(streamId, name, value, metricType, true);
    }

    public void send_tuple(String stream, int num_out_tasks) {
        if (JStormMetrics.enabled && num_out_tasks > 0) {
            this.update(stream, "Emitted", num_out_tasks, MetricType.COUNTER);
            this.update(stream, "SendTps", num_out_tasks, MetricType.METER);
        }
    }

    public void recv_tuple(String component, String stream) {
        if (JStormMetrics.enabled) {
            this.update(stream, this.fastConcat(component, "RecvTps"), 1, MetricType.METER);
        }
    }

    public void bolt_acked_tuple(String component, String stream, long latencyStart, long lifeCycleStart, long endTime) {
        if (JStormMetrics.enabled) {
            this.update(stream, "Acked", 1, MetricType.COUNTER);
            this.updateTime(stream, "ProcessLatency", latencyStart, endTime, false);
            this.updateTime(stream, this.fastConcat(component, "TupleLifeCycle"), lifeCycleStart, endTime, false);
        }
    }

    public void bolt_failed_tuple(String component, String stream) {
        if (JStormMetrics.enabled) {
            this.update(stream, "Failed", 1, MetricType.COUNTER);
        }
    }

    public void spout_acked_tuple(String stream, long latencyStart, long lifeCycleStart, long endTime) {
        if (JStormMetrics.enabled) {
            this.update(stream, "Acked", 1, MetricType.COUNTER);
            this.updateTime(stream, "ProcessLatency", latencyStart, endTime, true);
            this.updateTime(stream, this.fastConcat("__acker", "TupleLifeCycle"), lifeCycleStart, endTime, false);
        }
    }

    private String fastConcat(String componentId, String metricName) {
        StringBuilder sb = new StringBuilder(32);
        return sb.append(componentId).append(".").append(metricName).toString();
    }

    public void spout_failed_tuple(String stream) {
        if (JStormMetrics.enabled) {
            this.update(stream, "Failed", 1, MetricType.COUNTER);
        }
    }
}

