/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.backpressure;

import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.Map;

public abstract class Backpressure {
    private static final String BACKPRESSURE_DELAY_TIME = "topology.backpressure.delay.time";
    protected volatile boolean isBackpressureEnable;
    protected volatile double highWaterMark;
    protected volatile double lowWaterMark;
    protected volatile double triggerBpRatio;
    protected volatile long sleepTime;

    public Backpressure(Map stormConf) {
        this.isBackpressureEnable = ConfigExtension.isBackpressureEnable(stormConf);
        this.highWaterMark = ConfigExtension.getBackpressureWaterMarkHigh(stormConf);
        this.lowWaterMark = ConfigExtension.getBackpressureWaterMarkLow(stormConf);
        this.triggerBpRatio = ConfigExtension.getBackpressureCoordinatorRatio(stormConf);
    }

    protected void updateConfig(Map stormConf) {
        long time;
        if (stormConf == null) {
            return;
        }
        if (stormConf.containsKey(ConfigExtension.TOPOLOGY_BACKPRESSURE_ENABLE)) {
            this.isBackpressureEnable = ConfigExtension.isBackpressureEnable(stormConf);
        }
        if (stormConf.containsKey(ConfigExtension.TOPOLOGY_BACKPRESSURE_WATER_MARK_HIGH)) {
            this.highWaterMark = ConfigExtension.getBackpressureWaterMarkHigh(stormConf);
        }
        if (stormConf.containsKey(ConfigExtension.TOPOLOGY_BACKPRESSURE_WATER_MARK_LOW)) {
            this.lowWaterMark = ConfigExtension.getBackpressureWaterMarkLow(stormConf);
        }
        if (stormConf.containsKey(ConfigExtension.TOPOLOGY_BACKPRESSURE_COORDINATOR_RATIO)) {
            this.triggerBpRatio = ConfigExtension.getBackpressureCoordinatorRatio(stormConf);
        }
        if (stormConf.containsKey(BACKPRESSURE_DELAY_TIME) && (time = JStormUtils.parseLong(stormConf, 0L).longValue()) != 0L) {
            this.sleepTime = time;
        }
    }

    public boolean isBackpressureConfigChange(Map stormConf) {
        if (stormConf == null) {
            return false;
        }
        return stormConf.containsKey(ConfigExtension.TOPOLOGY_BACKPRESSURE_ENABLE) || stormConf.containsKey(ConfigExtension.TOPOLOGY_BACKPRESSURE_WATER_MARK_HIGH) || stormConf.containsKey(ConfigExtension.TOPOLOGY_BACKPRESSURE_WATER_MARK_LOW) || stormConf.containsKey(ConfigExtension.TOPOLOGY_BACKPRESSURE_COORDINATOR_RATIO) || stormConf.containsKey(BACKPRESSURE_DELAY_TIME);
    }
}

