/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.backpressure;

import com.alibaba.jstorm.task.backpressure.TargetBackpressureInfo;
import com.alibaba.jstorm.task.master.TopoMasterCtrlEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SourceBackpressureInfo
implements Serializable {
    private static final long serialVersionUID = -8213491092461721871L;
    private Set<Integer> tasks = new TreeSet<Integer>();
    private Map<String, TargetBackpressureInfo> targetTasks = new HashMap<String, TargetBackpressureInfo>();

    public Set<Integer> getTasks() {
        return this.tasks;
    }

    public Map<String, TargetBackpressureInfo> getTargetTasks() {
        return this.targetTasks;
    }

    public long getLastestTimeStamp() {
        long ret = 0L;
        for (Map.Entry<String, TargetBackpressureInfo> entry : this.targetTasks.entrySet()) {
            TargetBackpressureInfo info = entry.getValue();
            if (info.getTimeStamp() <= ret) continue;
            ret = info.getTimeStamp();
        }
        return ret;
    }

    public TopoMasterCtrlEvent.EventType getLastestBackpressureEvent() {
        TopoMasterCtrlEvent.EventType ret = null;
        long timeStamp = 0L;
        for (Map.Entry<String, TargetBackpressureInfo> entry : this.targetTasks.entrySet()) {
            TargetBackpressureInfo info = entry.getValue();
            if (info.getTimeStamp() <= timeStamp) continue;
            timeStamp = info.getTimeStamp();
            ret = info.getBackpressureStatus();
        }
        return ret;
    }

    public int getMaxFlowCtrlTime() {
        int ret = 0;
        for (Map.Entry<String, TargetBackpressureInfo> entry : this.targetTasks.entrySet()) {
            TargetBackpressureInfo info = entry.getValue();
            if (info.getFlowCtrlTime() <= ret) continue;
            ret = info.getFlowCtrlTime();
        }
        return ret;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

