/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.comm;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Tuple;
import com.alibaba.jstorm.daemon.worker.JStormDebugger;
import com.alibaba.jstorm.task.TaskBaseMetric;
import com.alibaba.jstorm.task.execute.MsgInfo;
import com.alibaba.jstorm.task.group.GrouperType;
import com.alibaba.jstorm.task.group.MkGrouper;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSendTargets {
    private static Logger LOG = LoggerFactory.getLogger(TaskSendTargets.class);
    private Map<Object, Object> stormConf;
    private TopologyContext topologyContext;
    private volatile Map<String, Map<String, MkGrouper>> streamComponentgrouper;
    private TaskBaseMetric taskStats;
    private String componentId;
    private int taskId;
    private String debugIdStr;

    public TaskSendTargets(Map<Object, Object> _storm_conf, String _component, Map<String, Map<String, MkGrouper>> _stream_component_grouper, TopologyContext _topology_context, TaskBaseMetric _task_stats) {
        this.stormConf = _storm_conf;
        this.componentId = _component;
        this.streamComponentgrouper = _stream_component_grouper;
        this.topologyContext = _topology_context;
        this.taskStats = _task_stats;
        this.taskId = this.topologyContext.getThisTaskId();
        this.debugIdStr = " emit from " + this.componentId + ":" + this.taskId + " ";
    }

    public List<Integer> get(Integer out_task_id, String stream, List<Object> tuple, Collection<Tuple> anchors, Object root_id) {
        if (this.isDebug(anchors, root_id)) {
            LOG.info(this.debugIdStr + stream + " to " + out_task_id + ":" + tuple.toString());
        }
        this.taskStats.send_tuple(stream, 1);
        ArrayList<Integer> out_tasks = new ArrayList<Integer>();
        out_tasks.add(out_task_id);
        return out_tasks;
    }

    public List<Integer> get(String stream, List<Object> tuple, Collection<Tuple> anchors, Object root_id) {
        ArrayList<Integer> out_tasks = new ArrayList<Integer>();
        Map<String, MkGrouper> componentCrouping = this.streamComponentgrouper.get(stream);
        if (componentCrouping == null) {
            LOG.debug("Failed to get Grouper of " + stream + " when " + this.debugIdStr);
            return out_tasks;
        }
        for (Map.Entry<String, MkGrouper> ee : componentCrouping.entrySet()) {
            String targetComponent = ee.getKey();
            MkGrouper g = ee.getValue();
            if (GrouperType.direct.equals((Object)g.gettype())) {
                throw new IllegalArgumentException("Cannot do regular emit to direct stream");
            }
            out_tasks.addAll(g.grouper(tuple));
        }
        if (this.isDebug(anchors, root_id)) {
            LOG.info(this.debugIdStr + stream + " to " + out_tasks + ":" + tuple.toString());
        }
        int num_out_tasks = out_tasks.size();
        this.taskStats.send_tuple(stream, num_out_tasks);
        return out_tasks;
    }

    public Map<List<Integer>, List<MsgInfo>> getBatch(Integer outTaskId, String stream, List<MsgInfo> batch) {
        HashMap<List<Integer>, List<MsgInfo>> outTasks = new HashMap<List<Integer>, List<MsgInfo>>();
        outTasks.put(JStormUtils.mk_list(outTaskId), batch);
        this.taskStats.send_tuple(stream, batch.size());
        return outTasks;
    }

    public Map<List<Integer>, List<MsgInfo>> getBatch(String stream, List<MsgInfo> batch) {
        HashMap<List<Integer>, List<MsgInfo>> outTasks = new HashMap<List<Integer>, List<MsgInfo>>();
        Map<String, MkGrouper> componentCrouping = this.streamComponentgrouper.get(stream);
        if (componentCrouping == null) {
            LOG.debug("Failed to get Grouper of " + stream + " in " + this.debugIdStr);
            return outTasks;
        }
        for (Map.Entry<String, MkGrouper> ee : componentCrouping.entrySet()) {
            MkGrouper g = ee.getValue();
            if (GrouperType.direct.equals((Object)g.gettype())) {
                throw new IllegalArgumentException("Cannot do regular emit to direct stream");
            }
            outTasks.putAll(g.grouperBatch(batch));
        }
        int num_out_tasks = 0;
        for (Map.Entry entry : outTasks.entrySet()) {
            num_out_tasks += ((List)entry.getKey()).size() * ((List)entry.getValue()).size();
        }
        this.taskStats.send_tuple(stream, num_out_tasks);
        return outTasks;
    }

    public void updateStreamCompGrouper(Map<String, Map<String, MkGrouper>> streamComponentgrouper) {
        this.streamComponentgrouper = streamComponentgrouper;
    }

    private boolean isDebug(Collection<Tuple> anchors, Object root_id) {
        if (root_id != null) {
            return JStormDebugger.isDebug(root_id);
        }
        if (anchors != null) {
            return JStormDebugger.isDebug(anchors);
        }
        return false;
    }
}

