/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.comm;

import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.BatchTuple;
import backtype.storm.tuple.TupleImplExt;
import com.alibaba.jstorm.task.TaskTransfer;
import com.alibaba.jstorm.task.comm.TaskSendTargets;
import java.util.List;

public class UnanchoredSend {
    public static void send(TopologyContext topologyContext, TaskSendTargets taskTargets, TaskTransfer transfer_fn, String stream, List<Object> values) {
        List<Integer> tasks = taskTargets.get(stream, values, null, values.get(0));
        if (tasks.size() == 0) {
            return;
        }
        Integer taskId = topologyContext.getThisTaskId();
        for (Integer task : tasks) {
            TupleImplExt tup = new TupleImplExt(topologyContext, values, taskId, stream);
            tup.setTargetTaskId(task);
            transfer_fn.transfer(tup);
        }
    }

    public static void sendBatch(TopologyContext topologyContext, TaskSendTargets taskTargets, TaskTransfer transfer_fn, String stream, List<Object> values) {
        List<Integer> tasks = taskTargets.get(stream, values, null, values.get(0));
        if (tasks.size() == 0) {
            return;
        }
        Integer taskId = topologyContext.getThisTaskId();
        for (Integer task : tasks) {
            TupleImplExt tup = new TupleImplExt(topologyContext, values, taskId, stream);
            tup.setTargetTaskId(task);
            BatchTuple batchTuple = new BatchTuple(taskId, 1);
            batchTuple.addToBatch(tup);
            transfer_fn.transfer(batchTuple);
        }
    }
}

