/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.error;

import com.alibaba.jstorm.cluster.StormClusterState;
import com.alibaba.jstorm.task.error.ITaskReportErr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskReportError
implements ITaskReportErr {
    private static Logger LOG = LoggerFactory.getLogger(TaskReportError.class);
    private StormClusterState zkCluster;
    private String topology_id;
    private int task_id;

    public TaskReportError(StormClusterState _storm_cluster_state, String _topology_id, int _task_id) {
        this.zkCluster = _storm_cluster_state;
        this.topology_id = _topology_id;
        this.task_id = _task_id;
    }

    @Override
    public void report(Throwable error) {
        LOG.error("Report error to /ZK/taskerrors/" + this.topology_id + "/" + this.task_id + "\n", error);
        try {
            this.zkCluster.report_task_error(this.topology_id, this.task_id, error);
        }
        catch (Exception e) {
            LOG.error("Failed update error to /ZK/taskerrors/" + this.topology_id + "/" + this.task_id + "\n", (Throwable)e);
        }
    }

    @Override
    public void report(String error) {
        LOG.error("Report error to /ZK/taskerrors/" + this.topology_id + "/" + this.task_id + ": " + error);
        try {
            this.zkCluster.report_task_error(this.topology_id, this.task_id, error, "error", 700);
        }
        catch (Exception e) {
            LOG.error("Failed update error to /ZK/taskerrors/" + this.topology_id + "/" + this.task_id + "\n", (Throwable)e);
        }
    }

    @Override
    public void report(String error, String errorLevel, int errorCode, int duration) {
        LOG.error("Report error to /ZK/taskerrors/" + this.topology_id + "/" + this.task_id + ": " + error);
        try {
            this.zkCluster.report_task_error(this.topology_id, this.task_id, error, errorLevel, errorCode, duration);
        }
        catch (Exception e) {
            LOG.error("Failed update error to /ZK/taskerrors/" + this.topology_id + "/" + this.task_id + "\n", (Throwable)e);
        }
    }
}

