/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.execute;

import backtype.storm.task.ICollectorCallback;
import backtype.storm.tuple.Tuple;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.daemon.worker.timer.TaskBatchFlushTrigger;
import com.alibaba.jstorm.task.execute.MsgInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchCollector {
    private static Logger LOG = LoggerFactory.getLogger(BatchCollector.class);
    protected Integer taskId;
    protected String componentId;
    protected Map conf;
    protected final Map<String, List<MsgInfo>> streamToBatches = new HashMap<String, List<MsgInfo>>();
    protected final Map<String, List<MsgInfo>> directBatches = new HashMap<String, List<MsgInfo>>();
    protected int batchSize;

    public BatchCollector(Integer taskId, String componentId, Map conf) {
        this.taskId = taskId;
        this.componentId = componentId;
        this.conf = conf;
        this.batchSize = ConfigExtension.getTaskMsgBatchSize(conf);
        int flushTime = ConfigExtension.getTaskMsgFlushInervalMs(conf);
        TaskBatchFlushTrigger batchFlushTrigger = new TaskBatchFlushTrigger(flushTime, componentId + "-" + taskId, this);
        batchFlushTrigger.register(TimeUnit.MILLISECONDS);
        LOG.info("BatchCollector: batchSize=" + this.batchSize + ", flushTime=" + flushTime);
    }

    public abstract List<MsgInfo> push(String var1, List<Object> var2, Integer var3, Collection<Tuple> var4, Object var5, Long var6, ICollectorCallback var7);

    public abstract void flush();
}

