/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.execute.spout;

import backtype.storm.spout.ISpout;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.TupleExt;
import com.alibaba.jstorm.client.spout.IAckValueSpout;
import com.alibaba.jstorm.daemon.worker.JStormDebugger;
import com.alibaba.jstorm.metric.JStormMetrics;
import com.alibaba.jstorm.task.TaskBaseMetric;
import com.alibaba.jstorm.task.comm.TupleInfo;
import com.alibaba.jstorm.task.execute.spout.IAckMsg;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AckSpoutMsg
implements IAckMsg {
    private static Logger LOG = LoggerFactory.getLogger(AckSpoutMsg.class);
    private Object id;
    private ISpout spout;
    private Tuple tuple;
    private TupleInfo tupleInfo;
    private Object msgId;
    private String stream;
    private List<Object> values;
    private TaskBaseMetric task_stats;

    public AckSpoutMsg(Object id, ISpout _spout, Tuple tuple, TupleInfo tupleInfo, TaskBaseMetric _task_stats) {
        this.id = id;
        this.task_stats = _task_stats;
        this.spout = _spout;
        this.msgId = tupleInfo.getMessageId();
        this.stream = tupleInfo.getStream();
        this.values = tupleInfo.getValues();
        this.tuple = tuple;
        this.tupleInfo = tupleInfo;
    }

    @Override
    public void run() {
        if (JStormDebugger.isDebug(this.id)) {
            LOG.info("Acking message rootId:{}, messageId:{}", this.id, this.msgId);
        }
        if (this.spout instanceof IAckValueSpout) {
            IAckValueSpout ackValueSpout = (IAckValueSpout)((Object)this.spout);
            ackValueSpout.ack(this.msgId, this.values);
        } else {
            this.spout.ack(this.msgId);
        }
        long latencyStart = this.tupleInfo.getTimestamp();
        long lifeCycleStart = 0L;
        if (latencyStart != 0L && JStormMetrics.enabled) {
            long endTime = System.currentTimeMillis();
            if (this.tuple != null && this.tuple instanceof TupleExt) {
                lifeCycleStart = ((TupleExt)this.tuple).getCreationTimeStamp();
            }
            this.task_stats.spout_acked_tuple(this.stream, latencyStart, lifeCycleStart, endTime);
        }
    }
}

