/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.execute.spout;

import backtype.storm.spout.ISpout;
import backtype.storm.utils.DisruptorQueue;
import com.alibaba.jstorm.task.TaskBaseMetric;
import com.alibaba.jstorm.task.comm.TupleInfo;
import com.alibaba.jstorm.task.execute.spout.FailSpoutMsg;
import com.alibaba.jstorm.utils.ExpiredCallback;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpoutTimeoutCallBack<K, V>
implements ExpiredCallback<K, V> {
    private static Logger LOG = LoggerFactory.getLogger(SpoutTimeoutCallBack.class);
    private DisruptorQueue disruptorEventQueue;
    private ISpout spout;
    private Map storm_conf;
    private TaskBaseMetric task_stats;

    public SpoutTimeoutCallBack(DisruptorQueue disruptorEventQueue, ISpout _spout, Map _storm_conf, TaskBaseMetric stat) {
        this.storm_conf = _storm_conf;
        this.disruptorEventQueue = disruptorEventQueue;
        this.spout = _spout;
        this.task_stats = stat;
    }

    @Override
    public void expire(K key, V val) {
        if (val == null) {
            return;
        }
        try {
            TupleInfo tupleInfo = (TupleInfo)val;
            FailSpoutMsg fail = new FailSpoutMsg(key, this.spout, tupleInfo, this.task_stats);
            this.disruptorEventQueue.publish(fail);
        }
        catch (Exception e) {
            LOG.error("expire error", (Throwable)e);
        }
    }
}

