/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.group;

import backtype.storm.tuple.Fields;
import com.alibaba.jstorm.task.execute.MsgInfo;
import com.alibaba.jstorm.utils.JStormUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MkFieldsGrouper {
    private Fields out_fields;
    private Fields group_fields;
    private List<Integer> out_tasks;
    private Map<Integer, List<Integer>> hash_targetTasks;

    public MkFieldsGrouper(Fields _out_fields, Fields _group_fields, List<Integer> _out_tasks) {
        for (String groupField : _group_fields) {
            _out_fields.fieldIndex(groupField);
        }
        this.out_fields = _out_fields;
        this.group_fields = _group_fields;
        this.out_tasks = _out_tasks;
        this.hash_targetTasks = new HashMap<Integer, List<Integer>>();
    }

    public List<Integer> grouper(List<Object> values) {
        int hashcode = this.out_fields.select(this.group_fields, values).hashCode();
        int group = Math.abs(hashcode % this.out_tasks.size());
        return JStormUtils.mk_list(this.out_tasks.get(group));
    }

    public void batchGrouper(List<MsgInfo> batch, Map<List<Integer>, List<MsgInfo>> ret) {
        HashMap<Integer, List<Object>> hashMsgs = new HashMap<Integer, List<Object>>();
        for (int i = 0; i < batch.size(); ++i) {
            MsgInfo msg = batch.get(i);
            int hashcode = this.out_fields.select(this.group_fields, msg.values).hashCode();
            int group = Math.abs(hashcode % this.out_tasks.size());
            List<Object> fieldBatch = (List<Object>)hashMsgs.get(group);
            if (fieldBatch == null) {
                fieldBatch = JStormUtils.mk_list(new Object[0]);
                hashMsgs.put(group, fieldBatch);
            }
            fieldBatch.add(msg);
        }
        for (Map.Entry entry : hashMsgs.entrySet()) {
            List<Integer> tasks = this.hash_targetTasks.get(entry.getKey());
            if (tasks == null) {
                tasks = JStormUtils.mk_list(this.out_tasks.get((Integer)entry.getKey()));
                this.hash_targetTasks.put((Integer)entry.getKey(), tasks);
            }
            ret.put(tasks, (List<MsgInfo>)entry.getValue());
        }
    }
}

