/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.group;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.generated.Grouping;
import backtype.storm.generated.JavaObject;
import backtype.storm.grouping.CustomStreamGrouping;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import backtype.storm.utils.Utils;
import com.alibaba.jstorm.daemon.worker.WorkerData;
import com.alibaba.jstorm.task.execute.MsgInfo;
import com.alibaba.jstorm.task.group.GrouperType;
import com.alibaba.jstorm.task.group.MkCustomGrouper;
import com.alibaba.jstorm.task.group.MkFieldsGrouper;
import com.alibaba.jstorm.task.group.MkLocalFirst;
import com.alibaba.jstorm.task.group.MkLocalShuffer;
import com.alibaba.jstorm.task.group.MkShuffer;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.RandomRange;
import com.alibaba.jstorm.utils.Thrift;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkGrouper {
    private static final Logger LOG = LoggerFactory.getLogger(MkGrouper.class);
    private TopologyContext topology_context;
    private Fields out_fields;
    private Grouping thrift_grouping;
    private Grouping._Fields fields;
    private GrouperType grouptype;
    private List<Integer> out_tasks;
    private List<Integer> local_tasks;
    private String streamId;
    private RandomRange randomrange;
    private Random random;
    private MkShuffer shuffer;
    private MkCustomGrouper custom_grouper;
    private MkFieldsGrouper fields_grouper;
    private MkLocalShuffer local_shuffer_grouper;
    private MkLocalFirst localFirst;

    public MkGrouper(TopologyContext _topology_context, Fields _out_fields, Grouping _thrift_grouping, List<Integer> _outTasks, String streamId, WorkerData workerData) {
        this.topology_context = _topology_context;
        this.out_fields = _out_fields;
        this.thrift_grouping = _thrift_grouping;
        this.streamId = streamId;
        this.out_tasks = new ArrayList<Integer>();
        this.out_tasks.addAll(_outTasks);
        Collections.sort(this.out_tasks);
        this.local_tasks = _topology_context.getThisWorkerTasks();
        this.fields = Thrift.groupingType(this.thrift_grouping);
        this.grouptype = this.parseGroupType(workerData);
        String id = _topology_context.getThisTaskId() + ":" + streamId;
        LOG.info(id + " grouptype is " + (Object)((Object)this.grouptype) + ", out_tasks is " + this.out_tasks + ", local_tasks" + this.local_tasks);
    }

    public GrouperType gettype() {
        return this.grouptype;
    }

    private GrouperType parseGroupType(WorkerData workerData) {
        GrouperType grouperType = null;
        if (Grouping._Fields.FIELDS.equals((Object)this.fields)) {
            if (Thrift.isGlobalGrouping(this.thrift_grouping)) {
                grouperType = GrouperType.global;
            } else {
                List<String> fields_group = Thrift.fieldGrouping(this.thrift_grouping);
                Fields fields = new Fields(fields_group);
                this.fields_grouper = new MkFieldsGrouper(this.out_fields, fields, this.out_tasks);
                grouperType = GrouperType.fields;
            }
        } else if (Grouping._Fields.ALL.equals((Object)this.fields)) {
            grouperType = GrouperType.all;
        } else if (Grouping._Fields.SHUFFLE.equals((Object)this.fields)) {
            grouperType = GrouperType.shuffle;
            this.shuffer = new MkShuffer(this.out_tasks, workerData);
        } else if (Grouping._Fields.NONE.equals((Object)this.fields)) {
            this.random = new Random();
            grouperType = GrouperType.none;
        } else if (Grouping._Fields.CUSTOM_OBJECT.equals((Object)this.fields)) {
            JavaObject jobj = this.thrift_grouping.get_custom_object();
            CustomStreamGrouping g = Thrift.instantiateJavaObject(jobj);
            int myTaskId = this.topology_context.getThisTaskId();
            String componentId = this.topology_context.getComponentId(myTaskId);
            GlobalStreamId stream = new GlobalStreamId(componentId, this.streamId);
            this.custom_grouper = new MkCustomGrouper(this.topology_context, g, stream, this.out_tasks, myTaskId);
            grouperType = GrouperType.custom_obj;
        } else if (Grouping._Fields.CUSTOM_SERIALIZED.equals((Object)this.fields)) {
            byte[] obj = this.thrift_grouping.get_custom_serialized();
            CustomStreamGrouping g = (CustomStreamGrouping)Utils.javaDeserialize(obj);
            int myTaskId = this.topology_context.getThisTaskId();
            String componentId = this.topology_context.getComponentId(myTaskId);
            GlobalStreamId stream = new GlobalStreamId(componentId, this.streamId);
            this.custom_grouper = new MkCustomGrouper(this.topology_context, g, stream, this.out_tasks, myTaskId);
            grouperType = GrouperType.custom_serialized;
        } else if (Grouping._Fields.DIRECT.equals((Object)this.fields)) {
            grouperType = GrouperType.direct;
        } else if (Grouping._Fields.LOCAL_OR_SHUFFLE.equals((Object)this.fields)) {
            grouperType = GrouperType.local_or_shuffle;
            this.local_shuffer_grouper = new MkLocalShuffer(this.local_tasks, this.out_tasks, workerData);
        } else if (Grouping._Fields.LOCAL_FIRST.equals((Object)this.fields)) {
            grouperType = GrouperType.localFirst;
            this.localFirst = new MkLocalFirst(this.local_tasks, this.out_tasks, workerData);
        }
        return grouperType;
    }

    public List<Integer> grouper(List<Object> values) {
        if (GrouperType.global.equals((Object)this.grouptype)) {
            return JStormUtils.mk_list(this.out_tasks.get(0));
        }
        if (GrouperType.fields.equals((Object)this.grouptype)) {
            return this.fields_grouper.grouper(values);
        }
        if (GrouperType.all.equals((Object)this.grouptype)) {
            return this.out_tasks;
        }
        if (GrouperType.shuffle.equals((Object)this.grouptype)) {
            return this.shuffer.grouper(values);
        }
        if (GrouperType.none.equals((Object)this.grouptype)) {
            int rnd = Math.abs(this.random.nextInt() % this.out_tasks.size());
            return JStormUtils.mk_list(this.out_tasks.get(rnd));
        }
        if (GrouperType.custom_obj.equals((Object)this.grouptype)) {
            return this.custom_grouper.grouper(values);
        }
        if (GrouperType.custom_serialized.equals((Object)this.grouptype)) {
            return this.custom_grouper.grouper(values);
        }
        if (GrouperType.local_or_shuffle.equals((Object)this.grouptype)) {
            return this.local_shuffer_grouper.grouper(values);
        }
        if (GrouperType.localFirst.equals((Object)this.grouptype)) {
            return this.localFirst.grouper(values);
        }
        LOG.warn("Unsupportted group type");
        return new ArrayList<Integer>();
    }

    public Map<List<Integer>, List<MsgInfo>> grouperBatch(List<MsgInfo> batch) {
        HashMap<List<Integer>, List<MsgInfo>> ret = new HashMap<List<Integer>, List<MsgInfo>>();
        if (GrouperType.local_or_shuffle.equals((Object)this.grouptype)) {
            ret.put(this.local_shuffer_grouper.grouper(null), batch);
        } else if (GrouperType.global.equals((Object)this.grouptype)) {
            ret.put(JStormUtils.mk_list(this.out_tasks.get(0)), batch);
        } else if (GrouperType.fields.equals((Object)this.grouptype)) {
            this.fields_grouper.batchGrouper(batch, ret);
        } else if (GrouperType.all.equals((Object)this.grouptype)) {
            ret.put(this.out_tasks, batch);
        } else if (GrouperType.shuffle.equals((Object)this.grouptype)) {
            ret.put(this.shuffer.grouper(null), batch);
        } else if (GrouperType.none.equals((Object)this.grouptype)) {
            int rnd = Math.abs(this.random.nextInt() % this.out_tasks.size());
            ret.put(JStormUtils.mk_list(this.out_tasks.get(rnd)), batch);
        } else if (GrouperType.custom_obj.equals((Object)this.grouptype) || GrouperType.custom_serialized.equals((Object)this.grouptype)) {
            for (int i = 0; i < batch.size(); ++i) {
                MsgInfo msg = batch.get(i);
                List<Integer> out = this.custom_grouper.grouper(msg.values);
                List<Object> customBatch = (List<Object>)ret.get(out);
                if (customBatch == null) {
                    customBatch = JStormUtils.mk_list(new Object[0]);
                    ret.put(out, customBatch);
                }
                customBatch.add(msg);
            }
        } else if (GrouperType.localFirst.equals((Object)this.grouptype)) {
            ret.put(this.localFirst.grouper(null), batch);
        } else {
            LOG.warn("Unsupportted group type");
        }
        return ret;
    }
}

