/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.group;

import backtype.storm.utils.DisruptorQueue;
import com.alibaba.jstorm.daemon.worker.WorkerData;
import com.alibaba.jstorm.task.group.Shuffer;
import com.alibaba.jstorm.utils.IntervalCheck;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.RandomRange;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkLocalFirst
extends Shuffer {
    private static final Logger LOG = LoggerFactory.getLogger(MkLocalFirst.class);
    private List<Integer> allOutTasks = new ArrayList<Integer>();
    private List<Integer> localOutTasks = new ArrayList<Integer>();
    private List<Integer> remoteOutTasks = new ArrayList<Integer>();
    private RandomRange randomrange;
    private RandomRange remoteRandomRange;
    private boolean isLocalWorkerAvail;
    private WorkerData workerData;
    private IntervalCheck intervalCheck = new IntervalCheck();

    public MkLocalFirst(List<Integer> workerTasks, List<Integer> allOutTasks, WorkerData workerData) {
        super(workerData);
        this.intervalCheck.setInterval(10L);
        this.allOutTasks.addAll(allOutTasks);
        this.workerData = workerData;
        ArrayList<Integer> localWorkerOutTasks = new ArrayList<Integer>();
        for (Integer outTask : allOutTasks) {
            if (!workerTasks.contains(outTask)) continue;
            localWorkerOutTasks.add(outTask);
        }
        this.remoteOutTasks.addAll(allOutTasks);
        if (localWorkerOutTasks.size() != 0) {
            this.isLocalWorkerAvail = true;
            this.localOutTasks.addAll(localWorkerOutTasks);
        } else {
            this.isLocalWorkerAvail = false;
        }
        this.randomrange = new RandomRange(this.localOutTasks.size());
        this.remoteRandomRange = new RandomRange(this.remoteOutTasks.size());
        LOG.info("Local out tasks:" + this.localOutTasks + ", Remote out tasks:" + this.remoteOutTasks);
    }

    @Override
    protected int getActiveTask(RandomRange randomrange, List<Integer> outTasks) {
        int index = randomrange.nextInt();
        int size = outTasks.size();
        int i = 0;
        for (i = 0; i < size; ++i) {
            float queueLoadRatio;
            Integer taskId = outTasks.get(index);
            boolean taskStatus = this.workerData.isOutboundTaskActive(taskId);
            DisruptorQueue exeQueue = this.workerData.getInnerTaskTransfer().get(taskId);
            float f = queueLoadRatio = exeQueue != null ? exeQueue.pctFull() : 0.0f;
            if (taskStatus && (double)queueLoadRatio < 1.0) break;
            index = randomrange.nextInt();
        }
        return i < size ? index : -1;
    }

    private List<Integer> intraGroup(List<Object> values) {
        if (this.localOutTasks.size() == 0) {
            return null;
        }
        int index = this.getActiveTask(this.randomrange, this.localOutTasks);
        if (index == -1) {
            return null;
        }
        return JStormUtils.mk_list(this.localOutTasks.get(index));
    }

    private List<Integer> interGroup(List<Object> values) {
        int index = this.getActiveTask(this.remoteRandomRange, this.remoteOutTasks);
        if (index == -1) {
            index = this.randomrange.nextInt();
        }
        return JStormUtils.mk_list(this.remoteOutTasks.get(index));
    }

    @Override
    public List<Integer> grouper(List<Object> values) {
        List<Integer> ret = this.intraGroup(values);
        if (ret == null) {
            ret = this.interGroup(values);
        }
        return ret;
    }

    public static void main(String[] args) {
    }
}

