/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.task.group;

import com.alibaba.jstorm.daemon.worker.WorkerData;
import com.alibaba.jstorm.task.group.Shuffer;
import com.alibaba.jstorm.utils.IntervalCheck;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.RandomRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkLocalShuffer
extends Shuffer {
    private static final Logger LOG = LoggerFactory.getLogger(MkLocalShuffer.class);
    private List<Integer> outTasks;
    private RandomRange randomrange;
    private Set<Integer> lastLocalNodeTasks;
    private IntervalCheck intervalCheck;
    private WorkerData workerData;
    private boolean isLocal;
    private final List<Integer> allTargetTasks = new ArrayList<Integer>();

    public MkLocalShuffer(List<Integer> workerTasks, List<Integer> allOutTasks, WorkerData workerData) {
        super(workerData);
        ArrayList<Integer> localOutTasks = new ArrayList<Integer>();
        this.allTargetTasks.addAll(allOutTasks);
        for (Integer outTask : allOutTasks) {
            if (!workerTasks.contains(outTask)) continue;
            localOutTasks.add(outTask);
        }
        this.workerData = workerData;
        this.intervalCheck = new IntervalCheck();
        this.intervalCheck.setInterval(60L);
        if (localOutTasks.size() != 0) {
            this.outTasks = localOutTasks;
            this.isLocal = true;
        } else {
            this.outTasks = new ArrayList<Integer>();
            this.outTasks.addAll(allOutTasks);
            this.refreshLocalNodeTasks();
            this.isLocal = false;
        }
        this.randomrange = new RandomRange(this.outTasks.size());
    }

    private void refreshLocalNodeTasks() {
        Set<Integer> localNodeTasks = this.workerData.getLocalNodeTasks();
        if (localNodeTasks == null || localNodeTasks.equals(this.lastLocalNodeTasks)) {
            return;
        }
        LOG.info("Old localNodeTasks:" + this.lastLocalNodeTasks + ", new:" + localNodeTasks);
        this.lastLocalNodeTasks = localNodeTasks;
        ArrayList<Integer> localNodeOutTasks = new ArrayList<Integer>();
        for (Integer outTask : this.allTargetTasks) {
            if (!localNodeTasks.contains(outTask)) continue;
            localNodeOutTasks.add(outTask);
        }
        if (!localNodeOutTasks.isEmpty()) {
            this.outTasks = localNodeOutTasks;
        }
        this.randomrange = new RandomRange(this.outTasks.size());
    }

    @Override
    public List<Integer> grouper(List<Object> values) {
        int index;
        if (!this.isLocal && this.intervalCheck.check()) {
            this.refreshLocalNodeTasks();
        }
        if ((index = this.getActiveTask(this.randomrange, this.outTasks)) == -1) {
            index = this.randomrange.nextInt();
        }
        return JStormUtils.mk_list(this.outTasks.get(index));
    }

    public static void main(String[] args) {
    }
}

