/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import backtype.storm.utils.DisruptorQueue;
import com.alibaba.jstorm.callback.AsyncLoopRunnable;
import com.alibaba.jstorm.callback.RunnableCallback;
import com.lmax.disruptor.EventHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DisruptorRunable
extends RunnableCallback
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DisruptorRunable.class);
    protected DisruptorQueue queue;
    protected String idStr;
    protected AtomicBoolean shutdown = AsyncLoopRunnable.getShutdown();

    public DisruptorRunable(DisruptorQueue queue, String idStr) {
        this.queue = queue;
        this.idStr = idStr;
    }

    public abstract void handleEvent(Object var1, boolean var2) throws Exception;

    public void onEvent(Object event, long sequence, boolean endOfBatch) throws Exception {
        if (event == null) {
            return;
        }
        this.handleEvent(event, endOfBatch);
    }

    @Override
    public void run() {
        LOG.info("Successfully start thread " + this.idStr);
        while (!this.shutdown.get()) {
            this.queue.consumeBatchWhenAvailable(this);
        }
        LOG.info("Successfully exit thread " + this.idStr);
    }

    @Override
    public void shutdown() {
    }
}

