/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import com.alibaba.jstorm.utils.IntervalCheck;
import com.alibaba.jstorm.utils.Pair;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class EventSampler {
    private volatile int freq;
    private AtomicInteger i = new AtomicInteger(0);
    private volatile int target;
    private Random r = new Random();
    private AtomicInteger counter = new AtomicInteger(0);
    private AtomicLong sum = new AtomicLong(0L);
    private IntervalCheck intervalCheck = new IntervalCheck();

    public EventSampler(int freq) {
        this.freq = freq;
        this.target = this.r.nextInt(freq);
        if (freq / 4 > 1) {
            this.intervalCheck.setInterval(freq / 4);
        }
    }

    public boolean countCheck() {
        this.i.incrementAndGet();
        if (this.i.get() > this.freq) {
            this.target = this.r.nextInt(this.freq);
            this.i.set(0);
        }
        return this.i.get() == this.target;
    }

    public Integer tpsCheck() {
        int send = this.counter.incrementAndGet();
        Double pastSeconds = this.intervalCheck.checkAndGet();
        if (pastSeconds != null) {
            this.counter.set(0);
            return (int)((double)send / pastSeconds);
        }
        return null;
    }

    public Integer timesCheck() {
        int send = this.counter.incrementAndGet();
        Double pastSeconds = this.intervalCheck.checkAndGet();
        if (pastSeconds != null) {
            this.counter.set(0);
            return send;
        }
        return null;
    }

    public Pair<Integer, Double> avgCheck(long one) {
        int send = this.counter.incrementAndGet();
        long total = this.sum.addAndGet(one);
        Double pastSeconds = this.intervalCheck.checkAndGet();
        if (pastSeconds != null) {
            this.counter.set(0);
            this.sum.set(0L);
            Double avg = 0.0;
            if (send != 0) {
                avg = (double)total / (double)send;
            }
            return new Pair<Integer, Double>(send, avg);
        }
        return null;
    }
}

