/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import java.io.Serializable;

public class IntervalCheck
implements Serializable {
    private static final long serialVersionUID = 8952971673547362883L;
    long lastCheck = System.currentTimeMillis();
    long interval = 1000L;

    public boolean check() {
        return this.checkAndGet() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double checkAndGet() {
        long now = System.currentTimeMillis();
        IntervalCheck intervalCheck = this;
        synchronized (intervalCheck) {
            if (now >= this.interval + this.lastCheck) {
                double pastSecond = (double)(now - this.lastCheck) / 1000.0;
                this.lastCheck = now;
                return pastSecond;
            }
        }
        return null;
    }

    public long getInterval() {
        return this.interval / 1000L;
    }

    public long getIntervalMs() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval * 1000L;
    }

    public void setIntervalMs(long interval) {
        this.interval = interval;
    }

    public void adjust(long addTimeMillis) {
        this.lastCheck += addTimeMillis;
    }

    public void start() {
        this.lastCheck = System.currentTimeMillis();
    }
}

