/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import backtype.storm.utils.Utils;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.NetWorkUtils;
import com.alibaba.jstorm.utils.PathUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JStormServerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JStormServerUtils.class);

    public static void downloadCodeFromMaster(Map conf, String localRoot, String masterCodeDir, String topologyId, boolean isSupervisor) throws IOException, TException {
        FileUtils.forceMkdir((File)new File(localRoot));
        FileUtils.forceMkdir((File)new File(StormConfig.stormlib_path(localRoot)));
        String localStormjarPath = StormConfig.stormjar_path(localRoot);
        String masterStormjarPath = StormConfig.stormjar_path(masterCodeDir);
        Utils.downloadFromMaster(conf, masterStormjarPath, localStormjarPath);
        String localStormcodePath = StormConfig.stormcode_path(localRoot);
        String masterStormcodePath = StormConfig.stormcode_path(masterCodeDir);
        Utils.downloadFromMaster(conf, masterStormcodePath, localStormcodePath);
        String localStormConfPath = StormConfig.stormconf_path(localRoot);
        String masterStormConfPath = StormConfig.stormconf_path(masterCodeDir);
        Utils.downloadFromMaster(conf, masterStormConfPath, localStormConfPath);
        Map stormConf = (Map)StormConfig.readLocalObject(topologyId, localStormConfPath);
        if (stormConf == null) {
            throw new IOException("Get topology conf error: " + topologyId);
        }
        List libs = (List)stormConf.get("topology.lib.name");
        if (libs == null) {
            return;
        }
        for (String libName : libs) {
            String localStromLibPath = StormConfig.stormlib_path(localRoot, libName);
            String masterStormLibPath = StormConfig.stormlib_path(masterCodeDir, libName);
            Utils.downloadFromMaster(conf, masterStormLibPath, localStromLibPath);
        }
    }

    public static void createPid(String dir) throws Exception {
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            throw new RuntimeException("pid dir:" + dir + " isn't directory");
        }
        String[] existPids = file.list();
        String pid = JStormUtils.process_pid();
        String pidPath = dir + File.separator + pid;
        PathUtils.touch(pidPath);
        LOG.info("Successfully touch pid  " + pidPath);
        for (String existPid : existPids) {
            try {
                JStormUtils.kill(Integer.valueOf(existPid));
                PathUtils.rmpath(dir + File.separator + existPid);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void startTaobaoJvmMonitor() {
    }

    public static boolean isOnePending(Map conf) {
        Object pending = conf.get("topology.max.spout.pending");
        if (pending == null) {
            return false;
        }
        int pendingNum = JStormUtils.parseInt(pending);
        return pendingNum == 1;
    }

    public static String getName(String componentId, int taskId) {
        return componentId + ":" + taskId;
    }

    public static String getHostName(Map conf) {
        String hostName = ConfigExtension.getSupervisorHost(conf);
        if (hostName == null) {
            hostName = NetWorkUtils.hostname();
        }
        if (ConfigExtension.isSupervisorUseIp(conf)) {
            hostName = NetWorkUtils.ip();
        }
        return hostName;
    }
}

