/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import com.alibaba.jstorm.utils.JStormUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class JStormSignalHandler
implements SignalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JStormSignalHandler.class);
    protected static JStormSignalHandler instance = null;
    protected Map<Integer, String> signalMap = new HashMap<Integer, String>();
    protected Map<Integer, Runnable> signalHandlers = new HashMap<Integer, Runnable>();
    protected Map<Integer, SignalHandler> oldSignalHandlers = new HashMap<Integer, SignalHandler>();
    protected Thread signalThread;
    protected LinkedBlockingDeque<Signal> waitingSignals = new LinkedBlockingDeque();
    protected boolean isRunning = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JStormSignalHandler getInstance() {
        Class<JStormSignalHandler> clazz = JStormSignalHandler.class;
        synchronized (JStormSignalHandler.class) {
            if (instance == null) {
                instance = new JStormSignalHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected JStormSignalHandler() {
        this.initSignalMap();
        this.initSignalThread();
    }

    protected void initSignalMap() {
        this.signalMap.put(1, "HUP");
        this.signalMap.put(2, "INT");
        this.signalMap.put(3, "QUIT");
        this.signalMap.put(4, "ILL");
        this.signalMap.put(5, "TRAP");
        this.signalMap.put(6, "ABRT");
        this.signalMap.put(6, "IOT");
        this.signalMap.put(7, "BUS");
        this.signalMap.put(8, "FPE");
        this.signalMap.put(9, "KILL");
        this.signalMap.put(10, "USR1");
        this.signalMap.put(11, "SEGV");
        this.signalMap.put(12, "USR2");
        this.signalMap.put(13, "PIPE");
        this.signalMap.put(14, "ALRM");
        this.signalMap.put(15, "TERM");
        this.signalMap.put(16, "STKFLT");
        this.signalMap.put(17, "CHLD");
        this.signalMap.put(18, "CONT");
        this.signalMap.put(19, "STOP");
        this.signalMap.put(20, "TSTP");
        this.signalMap.put(21, "TTIN");
        this.signalMap.put(22, "TTOU");
        this.signalMap.put(23, "URG");
        this.signalMap.put(24, "XCPU");
        this.signalMap.put(25, "XFSZ");
        this.signalMap.put(26, "VTALRM");
        this.signalMap.put(27, "PROF");
        this.signalMap.put(28, "WINCH");
        this.signalMap.put(29, "IO");
        this.signalMap.put(30, "PWR");
        this.signalMap.put(31, "SYS");
        this.signalMap.put(32, "UNUSED");
    }

    protected void initSignalThread() {
        this.signalThread = new Thread(new SignalRunnable());
        this.signalThread.setDaemon(true);
        this.signalThread.setName("SignalRunnable");
        this.signalThread.start();
    }

    public synchronized void registerSignal(int signalNumber, Runnable callback, boolean replace) {
        String signalName = this.signalMap.get(signalNumber);
        if (signalName == null) {
            LOG.warn("Invalid signalNumber " + signalNumber);
            return;
        }
        LOG.info("Begin to register signal of {}", (Object)signalName);
        try {
            SignalHandler oldHandler = Signal.handle(new Signal(signalName), this);
            LOG.info("Successfully register {} handler", (Object)signalName);
            Runnable old = this.signalHandlers.put(signalNumber, callback);
            if (old != null) {
                if (!replace) {
                    this.oldSignalHandlers.put(signalNumber, oldHandler);
                } else {
                    LOG.info("Successfully old {} handler will be replaced", (Object)signalName);
                }
            }
            LOG.info("Successfully register signal of {}", (Object)signalName);
            return;
        }
        catch (Exception e) {
            LOG.error("Failed to register " + signalName + ":" + signalNumber + ", Signal already used by VM or OS: SIGILL");
            return;
        }
    }

    @Override
    public void handle(Signal signal) {
        this.waitingSignals.offer(signal);
    }

    public boolean cleanUp() {
        LOG.info("Cleaning up!");
        this.isRunning = false;
        return true;
    }

    public static void registerJStormSignalHandler() {
        int[] signals;
        JStormSignalHandler instance = JStormSignalHandler.getInstance();
        for (int signal : signals = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 10, 11, 12, 14, 16}) {
            instance.registerSignal(signal, null, false);
        }
    }

    public static void main(String[] args) {
        JStormSignalHandler instance = JStormSignalHandler.getInstance();
        JStormSignalHandler.registerJStormSignalHandler();
        while (true) {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected class SignalRunnable
    implements Runnable {
        protected SignalRunnable() {
        }

        @Override
        public void run() {
            LOG.info("Start");
            while (JStormSignalHandler.this.isRunning) {
                Signal signal = null;
                try {
                    signal = JStormSignalHandler.this.waitingSignals.take();
                    if (signal == null) continue;
                    this.handle(signal);
                }
                catch (Throwable e) {
                    LOG.error("Failed to handle " + e.getCause(), e);
                }
            }
            LOG.info("End");
        }

        public void handle(Signal signal) {
            LOG.info("Receive singal " + signal.getName() + " " + signal.getNumber());
            Runnable runner = JStormSignalHandler.this.signalHandlers.get(signal.getNumber());
            try {
                if (runner == null) {
                    LOG.info("Skip JStorm register handler of signal: {}", (Object)signal.getName());
                } else {
                    LOG.info("Begin to handle signal of {}", (Object)signal.getName());
                    runner.run();
                    LOG.info("Successfully handle signal of {}", (Object)signal.getName());
                }
            }
            catch (Throwable e) {
                LOG.error("Failed to handle signal of " + signal.getName() + ":" + e.getCause(), e);
            }
            try {
                SignalHandler oldHandler = JStormSignalHandler.this.oldSignalHandlers.get(signal.getNumber());
                if (oldHandler != null) {
                    LOG.info("Begin to run the old singleHandler");
                    oldHandler.handle(signal);
                    JStormUtils.sleepMs(1000L);
                    LOG.info("Successfully run the old singleHandler");
                }
            }
            catch (Throwable e) {
                LOG.error("Failed to run old SignalHandler of  signal: " + signal.getName() + ":" + e.getCause(), e);
            }
        }
    }
}

