/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import backtype.storm.utils.Utils;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import com.alibaba.jstorm.callback.AsyncLoopDefaultKill;
import com.alibaba.jstorm.callback.RunnableCallback;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.utils.JStormSignalHandler;
import com.alibaba.jstorm.utils.LinuxResource;
import com.alibaba.jstorm.utils.OSInfo;
import com.alibaba.jstorm.utils.SystemOperation;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.ObjectName;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JStormUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JStormUtils.class);
    public static long SIZE_1_K = 1024L;
    public static long SIZE_1_M = SIZE_1_K * 1024L;
    public static long SIZE_1_G = SIZE_1_M * 1024L;
    public static long SIZE_1_T = SIZE_1_G * 1024L;
    public static long SIZE_1_P = SIZE_1_T * 1024L;
    public static final int MIN_1 = 60;
    public static final int MIN_30 = 1800;
    public static final int HOUR_1 = 3600;
    public static final int DAY_1 = 86400;
    public static boolean localMode = false;
    public static String HEXES = "0123456789ABCDEF";

    public static String getErrorInfo(String baseInfo, Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return baseInfo + "\r\n" + sw.toString() + "\r\n";
        }
        catch (Exception e2) {
            return baseInfo;
        }
    }

    public static String getErrorInfo(Throwable error) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            error.printStackTrace(pw);
            return sw.toString();
        }
        catch (Exception e1) {
            return "";
        }
    }

    public static <K, V> Map<K, V> select_keys_pred(Set<K> filter, Map<K, V> all) {
        HashMap<K, V> filterMap = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : all.entrySet()) {
            if (filter.contains(entry.getKey())) continue;
            filterMap.put(entry.getKey(), entry.getValue());
        }
        return filterMap;
    }

    public static byte[] barr(byte v) {
        byte[] byteArray = new byte[]{v};
        return byteArray;
    }

    public static byte[] barr(Short v) {
        byte[] byteArray = new byte[2];
        for (int i = 0; i < byteArray.length; ++i) {
            int off = (byteArray.length - 1 - i) * 8;
            byteArray[i] = (byte)(v >> off & 0xFF);
        }
        return byteArray;
    }

    public static byte[] barr(Integer v) {
        byte[] byteArray = new byte[4];
        for (int i = 0; i < byteArray.length; ++i) {
            int off = (byteArray.length - 1 - i) * 8;
            byteArray[i] = (byte)(v >> off & 0xFF);
        }
        return byteArray;
    }

    public static int byteToInt2(byte[] b) {
        int iOutcome = 0;
        for (int i = 0; i < 4; ++i) {
            byte bLoop = b[i];
            int off = (b.length - 1 - i) * 8;
            iOutcome += (bLoop & 0xFF) << off;
        }
        return iOutcome;
    }

    public static boolean isLocalMode() {
        return localMode;
    }

    public static void setLocalMode(boolean localMode) {
        JStormUtils.localMode = localMode;
    }

    public static void haltProcess(int val) {
        Runtime.getRuntime().halt(val);
    }

    public static void halt_process(int val, String msg) {
        LOG.info("Halting process: " + msg);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!localMode || val != 0) {
            JStormUtils.haltProcess(val);
        }
    }

    public static <K, V> HashMap<V, List<K>> reverse_map(Map<K, V> map) {
        HashMap<V, ArrayList<K>> rtn = new HashMap<V, ArrayList<K>>();
        if (map == null) {
            return rtn;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V val = entry.getValue();
            ArrayList<K> list2 = (ArrayList<K>)rtn.get(val);
            if (list2 == null) {
                list2 = new ArrayList<K>();
                rtn.put(entry.getValue(), list2);
            }
            list2.add(key);
        }
        return rtn;
    }

    public static String process_pid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = name.split("@");
        if (split.length != 2) {
            throw new RuntimeException("Got unexpected process name: " + name);
        }
        return split[0];
    }

    public static void exec_command(String command) throws ExecuteException, IOException {
        JStormUtils.launchProcess(command, new HashMap<String, String>(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractDirFromJar(String jarpath, String dir, String destdir) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(jarpath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries != null && entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                if (ze.isDirectory() || !ze.getName().startsWith(dir)) continue;
                InputStream in = zipFile.getInputStream(ze);
                try {
                    File file = new File(destdir, ze.getName());
                    if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                        throw new IOException("Mkdirs failed to create " + file.getParentFile().toString());
                    }
                    try (FileOutputStream out = new FileOutputStream(file);){
                        int i;
                        byte[] buffer = new byte[8192];
                        while ((i = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, i);
                        }
                    }
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
        catch (Exception e) {
            LOG.warn("No " + dir + " from " + jarpath + "!\n" + e.getMessage());
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception e) {
                    LOG.warn(e.getMessage());
                }
            }
        }
    }

    public static void ensure_process_killed(Integer pid) {
        for (int i = 0; i < 5; ++i) {
            try {
                JStormUtils.exec_command("kill -9 " + pid);
                LOG.info("kill -9 process " + pid);
                JStormUtils.sleepMs(100L);
                continue;
            }
            catch (ExecuteException e) {
                LOG.info("Error when trying to kill " + pid + ". Process has been killed");
                continue;
            }
            catch (Exception e) {
                LOG.info("Error when trying to kill " + pid + ".Exception ", (Throwable)e);
            }
        }
    }

    public static void process_killed(Integer pid) {
        try {
            JStormUtils.exec_command("kill " + pid);
            LOG.info("kill process " + pid);
        }
        catch (ExecuteException e) {
            LOG.info("Error when trying to kill " + pid + ". Process has been killed. ");
        }
        catch (Exception e) {
            LOG.info("Error when trying to kill " + pid + ".Exception ", (Throwable)e);
        }
    }

    public static void kill(Integer pid) {
        JStormUtils.process_killed(pid);
        JStormUtils.sleepMs(5000L);
        JStormUtils.ensure_process_killed(pid);
    }

    public static void kill_signal(Integer pid, String signal) {
        String cmd = "kill " + signal + " " + pid;
        try {
            JStormUtils.exec_command(cmd);
            LOG.info(cmd);
        }
        catch (ExecuteException e) {
            LOG.info("Error when run " + cmd + ". Process has been killed. ");
        }
        catch (Exception e) {
            LOG.info("Error when run " + cmd + ". Exception ", (Throwable)e);
        }
    }

    public static boolean isProcDead(String pid) {
        if (!OSInfo.isLinux()) {
            return false;
        }
        String path = "/proc/" + pid;
        File file = new File(path);
        if (!file.exists()) {
            LOG.info("Process " + pid + " is dead");
            return true;
        }
        return false;
    }

    public static Double getCpuUsage() {
        Double value;
        if (!OSInfo.isLinux()) {
            return 0.0;
        }
        String output = null;
        try {
            String pid = JStormUtils.process_pid();
            String command = String.format("top -b -n 1 -p %s | grep -w %s", pid, pid);
            output = SystemOperation.exec(command);
            String subStr = output.substring(output.indexOf("S") + 1);
            for (int i = 0; i < subStr.length(); ++i) {
                char ch = subStr.charAt(i);
                if (ch == ' ') continue;
                subStr = subStr.substring(i);
                break;
            }
            String usedCpu = subStr.substring(0, subStr.indexOf(" "));
            value = Double.valueOf(usedCpu);
        }
        catch (Exception e) {
            LOG.warn("Failed to get cpu usage ratio.");
            if (output != null) {
                LOG.warn("Output string is \"" + output + "\"");
            }
            value = 0.0;
        }
        return value;
    }

    public static double getTotalCpuUsage() {
        if (!OSInfo.isLinux()) {
            return 0.0;
        }
        return LinuxResource.getCpuUsage();
    }

    public static Double getDiskUsage() {
        if (!OSInfo.isLinux() && !OSInfo.isMac()) {
            return 0.0;
        }
        try {
            String pct;
            String[] parts;
            String[] lines;
            String output = SystemOperation.exec("df -h /home");
            if (output != null && (lines = output.split("[\\r\\n]+")).length >= 2 && (parts = lines[1].split("\\s+")).length >= 5 && (pct = parts[4]).endsWith("%")) {
                return (double)Integer.valueOf(pct.substring(0, pct.length() - 1)).intValue() / 100.0;
            }
        }
        catch (Exception e) {
            LOG.warn("failed to get disk usage.");
        }
        return 0.0;
    }

    public static double getTotalMemUsage() {
        if (!OSInfo.isLinux()) {
            return 0.0;
        }
        try {
            List lines = IOUtils.readLines((InputStream)new FileInputStream("/proc/meminfo"));
            String total = ((String)lines.get(0)).split("\\s+")[1];
            String free = ((String)lines.get(1)).split("\\s+")[1];
            return 1.0 - Double.valueOf(free) / Double.valueOf(total);
        }
        catch (Exception ignored) {
            LOG.warn("failed to get total memory usage.");
            return 0.0;
        }
    }

    public static Long getFreePhysicalMem() {
        if (!OSInfo.isLinux()) {
            return 0L;
        }
        try {
            List lines = IOUtils.readLines((InputStream)new FileInputStream("/proc/meminfo"));
            String free = ((String)lines.get(1)).split("\\s+")[1];
            return Long.valueOf(free);
        }
        catch (Exception ignored) {
            LOG.warn("failed to get total free memory.");
            return 0L;
        }
    }

    public static int getNumProcessors() {
        int sysCpuNum = 0;
        try {
            sysCpuNum = Runtime.getRuntime().availableProcessors();
        }
        catch (Exception e) {
            LOG.info("Failed to get CPU cores .");
        }
        return sysCpuNum;
    }

    public static Double getMemUsage() {
        if (OSInfo.isLinux()) {
            try {
                String pid = JStormUtils.process_pid();
                String command = String.format("top -b -n 1 -p %s | grep -w %s", pid, pid);
                String output = SystemOperation.exec(command);
                int m = 0;
                String[] strArray = output.split(" ");
                for (int i = 0; i < strArray.length; ++i) {
                    String info = strArray[i];
                    if (info.trim().length() == 0) continue;
                    if (m == 5) {
                        Double value;
                        String unit = info.substring(info.length() - 1);
                        if (unit.equalsIgnoreCase("g")) {
                            value = Double.parseDouble(info.substring(0, info.length() - 1));
                            value = value * 1.0E9;
                        } else if (unit.equalsIgnoreCase("m")) {
                            value = Double.parseDouble(info.substring(0, info.length() - 1));
                            value = value * 1000000.0;
                        } else {
                            value = Double.parseDouble(info);
                        }
                        return value;
                    }
                    if (m == 8) {
                        // empty if block
                    }
                    if (m == 9) {
                        // empty if block
                    }
                    ++m;
                }
            }
            catch (Exception e) {
                LOG.warn("Failed to get memory usage .");
            }
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        return memoryUsage.getUsed();
    }

    public static double getJVMHeapMemory() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
        return memoryUsage.getUsed();
    }

    public static void registerJStormSignalHandler() {
        int[] signals;
        if (!OSInfo.isLinux()) {
            LOG.info("Skip register signal for current OS");
            return;
        }
        JStormSignalHandler instance = JStormSignalHandler.getInstance();
        for (int signal : signals = new int[]{1, 2, 5, 6, 7, 12, 14, 16}) {
            instance.registerSignal(signal, null, true);
        }
    }

    @Deprecated
    public static ByteArrayOutputStream launchProcess(String command, Map environment, String workDir, ExecuteResultHandler resultHandler) throws IOException {
        ByteArrayOutputStream out;
        PumpStreamHandler streamHandler;
        String[] cmdlist = command.split(" ");
        CommandLine cmd = new CommandLine(cmdlist[0]);
        for (String cmdItem : cmdlist) {
            if (StringUtils.isBlank((String)cmdItem)) continue;
            cmd.addArgument(cmdItem);
        }
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(0);
        if (!StringUtils.isBlank((String)workDir)) {
            executor.setWorkingDirectory(new File(workDir));
        }
        if ((streamHandler = new PumpStreamHandler((OutputStream)(out = new ByteArrayOutputStream()), (OutputStream)out)) != null) {
            executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
        }
        try {
            if (resultHandler == null) {
                executor.execute(cmd, environment);
            } else {
                executor.execute(cmd, environment, resultHandler);
            }
        }
        catch (ExecuteException executeException) {
            // empty catch block
        }
        return out;
    }

    protected static Process launchProcess(List<String> cmdlist, Map<String, String> environment) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(cmdlist);
        builder.redirectErrorStream(true);
        Map<String, String> process_evn = builder.environment();
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            process_evn.put(entry.getKey(), entry.getValue());
        }
        return builder.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOutput(InputStream input) {
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String launchProcess(final String command, final List<String> cmdlist, final Map<String, String> environment, boolean backend) throws IOException {
        if (backend) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ArrayList<String> cmdWrapper = new ArrayList<String>();
                    cmdWrapper.add("nohup");
                    cmdWrapper.addAll(cmdlist);
                    cmdWrapper.add("&");
                    try {
                        JStormUtils.launchProcess(cmdWrapper, environment);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to run nohup " + command + " &," + e.getCause(), (Throwable)e);
                    }
                }
            }).start();
            return null;
        }
        try {
            Process process = JStormUtils.launchProcess(cmdlist, environment);
            StringBuilder sb = new StringBuilder();
            String output = JStormUtils.getOutput(process.getInputStream());
            String errorOutput = JStormUtils.getOutput(process.getErrorStream());
            sb.append(output);
            sb.append("\n");
            sb.append(errorOutput);
            int ret = process.waitFor();
            if (ret != 0) {
                LOG.warn(command + " is terminated abnormally. ret={}, str={}", (Object)ret, (Object)sb.toString());
            }
            return sb.toString();
        }
        catch (Throwable e) {
            LOG.error("Failed to run " + command + ", " + e.getCause(), e);
            return "";
        }
    }

    public static String launchProcess(String command, Map<String, String> environment, boolean backend) throws IOException {
        String[] cmds = command.split(" ");
        ArrayList<String> cmdList = new ArrayList<String>();
        for (String tok : cmds) {
            if (StringUtils.isBlank((String)tok)) continue;
            cmdList.add(tok);
        }
        return JStormUtils.launchProcess(command, cmdList, environment, backend);
    }

    public static String current_classpath() {
        return System.getProperty("java.class.path");
    }

    public static String to_json(Map m) {
        return Utils.to_json(m);
    }

    public static Object from_json(String json) {
        return Utils.from_json(json);
    }

    public static <V> HashMap<V, Integer> multi_set(List<V> list2) {
        HashMap<V, Integer> rtn = new HashMap<V, Integer>();
        for (V v : list2) {
            int cnt = 1;
            if (rtn.containsKey(v)) {
                cnt += ((Integer)rtn.get(v)).intValue();
            }
            rtn.put(v, cnt);
        }
        return rtn;
    }

    public static List<String> getRepeat(List<String> list2) {
        ArrayList<String> rtn = new ArrayList<String>();
        HashSet<String> idSet = new HashSet<String>();
        for (String id : list2) {
            if (idSet.contains(id)) {
                rtn.add(id);
                continue;
            }
            idSet.add(id);
        }
        return rtn;
    }

    public static <T> List<T> interleave_all(List<List<T>> splitup) {
        ArrayList<T> rtn = new ArrayList<T>();
        int maxLength = 0;
        for (List<T> e : splitup) {
            int len = e.size();
            if (maxLength >= len) continue;
            maxLength = len;
        }
        for (int i = 0; i < maxLength; ++i) {
            for (List<T> e : splitup) {
                if (e.size() <= i) continue;
                rtn.add(e.get(i));
            }
        }
        return rtn;
    }

    public static long bit_xor_vals(Object ... vals) {
        long rtn = 0L;
        for (Object n : vals) {
            rtn = JStormUtils.bit_xor(rtn, n);
        }
        return rtn;
    }

    public static <T> long bit_xor_vals(List<T> vals) {
        long rtn = 0L;
        for (T n : vals) {
            rtn = JStormUtils.bit_xor(rtn, n);
        }
        return rtn;
    }

    public static <T> long bit_xor_vals_sets(Set<T> vals) {
        long rtn = 0L;
        for (T n : vals) {
            rtn = JStormUtils.bit_xor(rtn, n);
        }
        return rtn;
    }

    public static long bit_xor(Object a, Object b) {
        if (a instanceof Long && b instanceof Long) {
            long rtn = (Long)a ^ (Long)b;
            return rtn;
        }
        if (b instanceof Set) {
            long bs = JStormUtils.bit_xor_vals_sets((Set)b);
            return JStormUtils.bit_xor(a, bs);
        }
        if (a instanceof Set) {
            long as = JStormUtils.bit_xor_vals_sets((Set)a);
            return JStormUtils.bit_xor(as, b);
        }
        long ai = Long.parseLong(String.valueOf(a));
        long bi = Long.parseLong(String.valueOf(b));
        long rtn = ai ^ bi;
        return rtn;
    }

    public static <V> List<V> mk_list(V ... args) {
        ArrayList<V> rtn = new ArrayList<V>();
        for (V o : args) {
            rtn.add(o);
        }
        return rtn;
    }

    public static <V> List<V> mk_list(Set<V> args) {
        ArrayList<V> rtn = new ArrayList<V>();
        if (args != null) {
            for (V o : args) {
                rtn.add(o);
            }
        }
        return rtn;
    }

    public static <V> List<V> mk_list(Collection<V> args) {
        ArrayList<V> rtn = new ArrayList<V>();
        if (args != null) {
            for (V o : args) {
                rtn.add(o);
            }
        }
        return rtn;
    }

    public static <V> V[] mk_arr(V ... args) {
        return args;
    }

    public static Long parseLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return Long.valueOf(String.valueOf(o));
        }
        if (o instanceof Integer) {
            Integer value = (Integer)o;
            return (long)value;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new RuntimeException("Invalid value " + o.getClass().getName() + " " + o);
    }

    public static Double parseDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return Double.valueOf(String.valueOf(o));
        }
        if (o instanceof Integer) {
            Integer value = (Integer)o;
            return ((Number)value).doubleValue();
        }
        if (o instanceof Long) {
            Long value = (Long)o;
            return ((Number)value).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        throw new RuntimeException("Invalid value " + o.getClass().getName() + " " + o);
    }

    public static Double parseDouble(Object o, double defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        try {
            return JStormUtils.parseDouble(o);
        }
        catch (Exception ignored) {
            return defaultValue;
        }
    }

    public static Long parseLong(Object o, long defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof String) {
            return Long.valueOf(String.valueOf(o));
        }
        if (o instanceof Integer) {
            Integer value = (Integer)o;
            return (long)value;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        return defaultValue;
    }

    public static Integer parseInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return Integer.parseInt(String.valueOf(o));
        }
        if (o instanceof Long) {
            long value = (Long)o;
            return (int)value;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new RuntimeException("Invalid value " + o.getClass().getName() + " " + o);
    }

    public static Integer parseInt(Object o, int defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof String) {
            return Integer.parseInt(String.valueOf(o));
        }
        if (o instanceof Long) {
            long value = (Long)o;
            return (int)value;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return defaultValue;
    }

    public static Boolean parseBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new RuntimeException("Invalid value " + o.getClass().getName() + " " + o);
    }

    public static boolean parseBoolean(Object o, boolean defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return defaultValue;
    }

    public static <V> Set<V> listToSet(List<V> list2) {
        if (list2 == null) {
            return null;
        }
        HashSet<V> set = new HashSet<V>();
        set.addAll(list2);
        return set;
    }

    public static boolean zipContainsDir(String zipfile, String resources) {
        Enumeration<? extends ZipEntry> entries = null;
        try {
            entries = new ZipFile(zipfile).entries();
            while (entries != null && entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                String name = ze.getName();
                if (!name.startsWith(resources + "/")) continue;
                return true;
            }
        }
        catch (IOException e) {
            LOG.error(e + "zipContainsDir error");
        }
        return false;
    }

    public static Object add(Object oldValue, Object newValue) {
        if (oldValue == null) {
            return newValue;
        }
        if (newValue == null) {
            return oldValue;
        }
        if (oldValue instanceof Long) {
            return (Long)oldValue + (Long)newValue;
        }
        if (oldValue instanceof Double) {
            return (Double)oldValue + (Double)newValue;
        }
        if (oldValue instanceof Integer) {
            return (Integer)oldValue + (Integer)newValue;
        }
        if (oldValue instanceof Float) {
            return Float.valueOf(((Float)oldValue).floatValue() + ((Float)newValue).floatValue());
        }
        if (oldValue instanceof Short) {
            return (Short)oldValue + (Short)newValue;
        }
        if (oldValue instanceof BigInteger) {
            return ((BigInteger)oldValue).add((BigInteger)newValue);
        }
        if (oldValue instanceof Number) {
            return ((Number)oldValue).doubleValue() + ((Number)newValue).doubleValue();
        }
        return null;
    }

    public static Object mergeList(List<Object> list2) {
        Object ret = null;
        for (Object value : list2) {
            ret = JStormUtils.add(ret, value);
        }
        return ret;
    }

    public static List<Object> mergeList(List<Object> result2, Object add) {
        if (add instanceof Collection) {
            for (Object o : (Collection)add) {
                result2.add(o);
            }
        } else if (add instanceof Set) {
            for (Object o : (Collection)add) {
                result2.add(o);
            }
        } else {
            result2.add(add);
        }
        return result2;
    }

    public static List<Object> distinctList(List<Object> input) {
        ArrayList<Object> retList = new ArrayList<Object>();
        for (Object object : input) {
            if (retList.contains(object)) continue;
            retList.add(object);
        }
        return retList;
    }

    public static <K, V> Map<K, V> mergeMapList(List<Map<K, V>> list2) {
        HashMap<K, Object> ret = new HashMap<K, Object>();
        for (Map<K, V> listEntry : list2) {
            if (listEntry == null) continue;
            for (Map.Entry<K, V> mapEntry : listEntry.entrySet()) {
                K key = mapEntry.getKey();
                V value = mapEntry.getValue();
                Object retValue = JStormUtils.add(ret.get(key), value);
                ret.put(key, retValue);
            }
        }
        return ret;
    }

    public static String formatSimpleDouble(Double value) {
        try {
            DecimalFormat form = new DecimalFormat("##0.000");
            String s = form.format(value);
            return s;
        }
        catch (Exception e) {
            return "0.000";
        }
    }

    public static double formatDoubleDecPoint2(Double value) {
        try {
            DecimalFormat form = new DecimalFormat("##.00");
            String s = form.format(value);
            return Double.valueOf(s);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static double formatDoubleDecPoint4(Double value) {
        try {
            DecimalFormat form = new DecimalFormat("###.0000");
            String s = form.format(value);
            return Double.valueOf(s);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static Double convertToDouble(Object value) {
        Double ret = value == null ? null : (value instanceof Integer ? Double.valueOf(((Integer)value).doubleValue()) : (value instanceof Long ? Double.valueOf(((Long)value).doubleValue()) : (value instanceof Float ? Double.valueOf(((Float)value).doubleValue()) : (value instanceof Double ? (Double)value : null))));
        return ret;
    }

    public static String formatValue(Object value) {
        if (value == null) {
            return "0";
        }
        if (value instanceof Long) {
            return String.valueOf((Long)value);
        }
        if (value instanceof Double) {
            return JStormUtils.formatSimpleDouble((Double)value);
        }
        return String.valueOf(value);
    }

    public static void sleepMs(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void sleepNs(int ns) {
        try {
            Thread.sleep(0L, ns);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String toPrintableString(byte[] buf) {
        if (buf == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (byte b : buf) {
            if (index % 10 == 0) {
                sb.append("\n");
            }
            ++index;
            sb.append(HEXES.charAt((b & 0xF0) >> 4));
            sb.append(HEXES.charAt(b & 0xF));
            sb.append(" ");
        }
        return sb.toString();
    }

    public static Long getPhysicMemorySize() {
        Object object;
        try {
            object = ManagementFactory.getPlatformMBeanServer().getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
        }
        catch (Exception e) {
            LOG.warn("Failed to get system physical memory size,", (Throwable)e);
            return null;
        }
        Long ret = (Long)object;
        return ret;
    }

    public static String genLogName(String topology, Integer port) {
        return topology + "-worker-" + port + ".log";
    }

    public static String getLogFileName() {
        try {
            Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
            if (rootLogger instanceof ch.qos.logback.classic.Logger) {
                ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)rootLogger;
                Iterator index = logbackLogger.iteratorForAppenders();
                while (index.hasNext()) {
                    Appender appender = (Appender)index.next();
                    if (!(appender instanceof FileAppender)) continue;
                    FileAppender fileAppender = (FileAppender)appender;
                    return fileAppender.getFile();
                }
            }
        }
        catch (Throwable e) {
            LOG.info("Failed to get root logger file name", (Object)e.getMessage());
            return null;
        }
        return null;
    }

    public static String getLogDir() {
        String file = JStormUtils.getLogFileName();
        if (file != null) {
            if (file.lastIndexOf(File.separator) < 0) {
                return "";
            }
            return file.substring(0, file.lastIndexOf(File.separator));
        }
        String stormHome = System.getProperty("jstorm.home");
        if (stormHome == null) {
            return "." + File.separator + "logs";
        }
        return stormHome + File.separator + "logs";
    }

    public static void redirectOutput(String file) throws Exception {
        System.out.println("Redirect output to " + file);
        FileOutputStream workerOut = new FileOutputStream(new File(file));
        PrintStream ps = new PrintStream(new BufferedOutputStream(workerOut), true);
        System.setOut(ps);
        System.setErr(ps);
        LOG.info("Successfully redirect System.out to " + file);
    }

    public static RunnableCallback getDefaultKillfn() {
        return new AsyncLoopDefaultKill();
    }

    public static TreeMap<Integer, Integer> integer_divided(int sum, int num_pieces) {
        return Utils.integerDivided(sum, num_pieces);
    }

    public static <K, V> HashMap<K, V> filter_val(RunnableCallback fn, Map<K, V> amap) {
        HashMap<K, V> rtn = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : amap.entrySet()) {
            V value = entry.getValue();
            Object result2 = fn.execute(value);
            if (result2 != Boolean.valueOf(true)) continue;
            rtn.put(entry.getKey(), value);
        }
        return rtn;
    }

    public static int getSupervisorPortNum(Map conf, int sysCpuNum, Long physicalMemSize, boolean reserved) {
        double cpuWeight = ConfigExtension.getSupervisorSlotsPortCpuWeight(conf);
        int cpuPortNum = (int)((double)sysCpuNum / cpuWeight);
        if (cpuPortNum < 1) {
            LOG.info("Invalid supervisor.slots.port.cpu.weight setting :" + cpuWeight + ", cpu cores:" + sysCpuNum);
            cpuPortNum = 1;
        }
        Double memWeight = ConfigExtension.getSupervisorSlotsPortMemWeight(conf);
        int memPortNum = Integer.MAX_VALUE;
        if (physicalMemSize == null) {
            LOG.info("Failed to get memory size");
        } else {
            LOG.info("Get system memory size :" + physicalMemSize);
            long workerMemSize = ConfigExtension.getMemSizePerWorker(conf);
            memPortNum = (int)((double)physicalMemSize.longValue() / ((double)workerMemSize * memWeight));
            if (memPortNum < 1) {
                LOG.info("Invalid worker.memory.size setting:" + workerMemSize);
                memPortNum = reserved ? 1 : 4;
            } else if (memPortNum < 4) {
                LOG.info("System memory is too small for Jstorm");
                memPortNum = reserved ? 1 : 4;
            }
        }
        return Math.min(cpuPortNum, memPortNum);
    }

    public static List<Integer> getSupervisorPortList(Map conf) {
        ArrayList<Integer> portList = (ArrayList<Integer>)conf.get("supervisor.slots.ports");
        if (portList != null && portList.size() > 0) {
            return portList;
        }
        int sysCpuNum = 4;
        try {
            sysCpuNum = Runtime.getRuntime().availableProcessors();
        }
        catch (Exception e) {
            LOG.info("Failed to get CPU cores, set cpu cores as 4");
        }
        Long physicalMemSize = JStormUtils.getPhysicMemorySize();
        if (physicalMemSize > 0x200000000L) {
            long reserveMemory = ConfigExtension.getStormMachineReserveMem(conf);
            if (physicalMemSize < reserveMemory) {
                throw new RuntimeException("ReserveMemory configured too larger ,because PhysicalMemSize is only :" + physicalMemSize);
            }
            physicalMemSize = physicalMemSize - reserveMemory;
        }
        int portNum = JStormUtils.getSupervisorPortNum(conf, sysCpuNum, physicalMemSize, false);
        int portBase = ConfigExtension.getSupervisorSlotsPortsBase(conf);
        portList = new ArrayList<Integer>();
        for (int i = 0; i < portNum; ++i) {
            portList.add(portBase + i);
        }
        return portList;
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.putLong(x);
        return buffer.array();
    }

    public static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }

    public static Object createDisruptorWaitStrategy(Map conf) {
        Object ret;
        String waitStrategy = (String)conf.get("topology.disruptor.wait.strategy");
        if (waitStrategy.contains("TimeoutBlockingWaitStrategy")) {
            long timeout = JStormUtils.parseLong(conf.get("topology.disruptor.wait.timeout"), 10L);
            ret = Utils.newInstance(waitStrategy, new Object[]{timeout, TimeUnit.MILLISECONDS});
        } else {
            ret = Utils.newInstance(waitStrategy);
        }
        return ret;
    }

    public static Object thriftToObject(Object obj) {
        HashMap ret = null;
        if (obj instanceof TBase) {
            ret = JStormUtils.thriftToMap((TBase)obj);
        } else if (obj instanceof List) {
            ret = new ArrayList();
            for (Object item : (List)obj) {
                ((List)((Object)ret)).add(JStormUtils.thriftToObject(item));
            }
        } else if (obj instanceof Map) {
            ret = new HashMap();
            Set entrySet = ((Map)obj).entrySet();
            for (Map.Entry entry : entrySet) {
                ((Map)ret).put(String.valueOf(entry.getKey()), JStormUtils.thriftToObject(entry.getValue()));
            }
        } else {
            ret = String.valueOf(obj);
        }
        return ret;
    }

    public static Map<String, Object> thriftToMap(TBase thriftObj) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int i = 1;
        TFieldIdEnum field = thriftObj.fieldForId(i);
        while (field != null) {
            if (thriftObj.isSet(field)) {
                Object obj = thriftObj.getFieldValue(field);
                ret.put(field.getFieldName(), JStormUtils.thriftToObject(obj));
            }
            field = thriftObj.fieldForId(++i);
        }
        return ret;
    }

    public static List<Map<String, Object>> thriftToMap(List thriftObjs) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (Object thriftObj : thriftObjs) {
            ret.add(JStormUtils.thriftToMap((TBase)thriftObj));
        }
        return ret;
    }

    public static long halfValueOfSum(long v1, long v2, boolean increment) {
        long ret = (v1 + v2) / 2L;
        if (increment) {
            ret += (v1 + v2) % 2L;
        }
        return ret;
    }
}

