/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import backtype.storm.utils.ShellUtils;
import com.alibaba.jstorm.utils.JStormUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxResource {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxResource.class);
    public static final long JIFFY_LENGTH_IN_MILLIS;
    private static final String PROCFS_MEMFILE = "/proc/meminfo";
    private static final Pattern PROCFS_MEMFILE_FORMAT;
    private static final String _MEMTOTAL = "MemTotal";
    private static final String _SWAPTOTAL = "SwapTotal";
    private static final String _MEMFREE = "MemFree";
    private static final String _SWAPFREE = "SwapFree";
    private static final String _INACTIVE = "Inactive";
    private static final String PROCFS_CPUINFO = "/proc/cpuinfo";
    private static final Pattern PROCESSOR_FORMAT;
    private static final String PROCFS_STAT = "/proc/stat";
    private static final Pattern CPU_TIME_FORMAT;
    private static String procfsMemFile;
    private static String procfsCpuFile;
    private static String procfsStatFile;
    private static long jiffyLengthInMillis;
    private static CpuUsageCalculator cpuUsageCalculator;
    private static long ramSize;
    private static long swapSize;
    private static long ramSizeFree;
    private static long swapSizeFree;
    private static long inactiveSize;
    private static int numProcessors;
    static boolean readMemInfoFile;
    static boolean readCpuInfoFile;

    private static void readProcMemInfoFile(boolean readAgain) {
        if (readMemInfoFile && !readAgain) {
            return;
        }
        FileParse fileParse = new FileParse(procfsMemFile, new LineParse(){

            @Override
            public void prepare() {
            }

            @Override
            public boolean parseLine(String line) {
                Matcher mat = PROCFS_MEMFILE_FORMAT.matcher(line);
                if (mat.find()) {
                    if (mat.group(1).equals(LinuxResource._MEMTOTAL)) {
                        ramSize = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(LinuxResource._SWAPTOTAL)) {
                        swapSize = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(LinuxResource._MEMFREE)) {
                        ramSizeFree = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(LinuxResource._SWAPFREE)) {
                        swapSizeFree = Long.parseLong(mat.group(2));
                    } else if (mat.group(1).equals(LinuxResource._INACTIVE)) {
                        inactiveSize = Long.parseLong(mat.group(2));
                    }
                }
                return false;
            }
        });
        fileParse.parse();
        readMemInfoFile = true;
    }

    private static void readProcCpuInfoFile() {
        if (readCpuInfoFile) {
            return;
        }
        FileParse fileParse = new FileParse(procfsCpuFile, new LineParse(){

            @Override
            public void prepare() {
                numProcessors = 0;
            }

            @Override
            public boolean parseLine(String line) {
                Matcher mat = PROCESSOR_FORMAT.matcher(line);
                if (mat.find()) {
                    numProcessors++;
                }
                return false;
            }
        });
        fileParse.parse();
        readCpuInfoFile = true;
    }

    private static void readProcStatFile() {
        FileParse fileParse = new FileParse(procfsStatFile, new LineParse(){

            @Override
            public void prepare() {
            }

            @Override
            public boolean parseLine(String line) {
                Matcher mat = CPU_TIME_FORMAT.matcher(line);
                if (mat.find()) {
                    long uTime = Long.parseLong(mat.group(1));
                    long nTime = Long.parseLong(mat.group(2));
                    long sTime = Long.parseLong(mat.group(3));
                    cpuUsageCalculator.updateElapsedJiffies(BigInteger.valueOf(uTime + nTime + sTime), LinuxResource.getCurrentTime());
                    return true;
                }
                return false;
            }
        });
        fileParse.parse();
    }

    static long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private static void readProcMemInfoFile() {
        LinuxResource.readProcMemInfoFile(false);
    }

    public static long getPhysicalMemorySize() {
        LinuxResource.readProcMemInfoFile();
        return ramSize * 1024L;
    }

    public static long getVirtualMemorySize() {
        LinuxResource.readProcMemInfoFile();
        return (ramSize + swapSize) * 1024L;
    }

    public static long getFreePhysicalMemorySize() {
        LinuxResource.readProcMemInfoFile(true);
        return (ramSizeFree + inactiveSize) * 1024L;
    }

    public static long getFreeVirtualMemorySize() {
        LinuxResource.readProcMemInfoFile(true);
        return (ramSizeFree + swapSizeFree + inactiveSize) * 1024L;
    }

    public static int getNumProcessors() {
        LinuxResource.readProcCpuInfoFile();
        return numProcessors;
    }

    public static float getCpuUsage() {
        LinuxResource.readProcStatFile();
        float overallCpuUsage = cpuUsageCalculator.getCpuTrackerUsagePercent();
        if (overallCpuUsage != -1.0f) {
            overallCpuUsage /= (float)LinuxResource.getNumProcessors();
        }
        return overallCpuUsage;
    }

    public static void main(String[] args) throws InterruptedException {
        while (true) {
            Thread.sleep(5000L);
            System.out.println(LinuxResource.getCpuUsage());
            System.out.println(LinuxResource.getFreePhysicalMemorySize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long jiffiesPerSecond = -1L;
        try {
            ShellUtils.ShellCommandExecutor shellExecutorClk = new ShellUtils.ShellCommandExecutor(new String[]{"getconf", "CLK_TCK"});
            shellExecutorClk.execute();
            jiffiesPerSecond = Long.parseLong(shellExecutorClk.getOutput().replace("\n", ""));
            JIFFY_LENGTH_IN_MILLIS = jiffiesPerSecond != -1L ? Math.round(1000.0 / (double)jiffiesPerSecond) : -1L;
        }
        catch (IOException e) {
            try {
                LOG.error(JStormUtils.getErrorInfo(e));
                JIFFY_LENGTH_IN_MILLIS = jiffiesPerSecond != -1L ? Math.round(1000.0 / (double)jiffiesPerSecond) : -1L;
            }
            catch (Throwable throwable) {
                JIFFY_LENGTH_IN_MILLIS = jiffiesPerSecond != -1L ? Math.round(1000.0 / (double)jiffiesPerSecond) : -1L;
                throw throwable;
            }
        }
        PROCFS_MEMFILE_FORMAT = Pattern.compile("^([a-zA-Z]*):[ \t]*([0-9]*)[ \t]kB");
        PROCESSOR_FORMAT = Pattern.compile("^processor[ \t]:[ \t]*([0-9]*)");
        CPU_TIME_FORMAT = Pattern.compile("^cpu[ \t]*([0-9]*)[ \t]*([0-9]*)[ \t]*([0-9]*)[ \t].*");
        procfsMemFile = PROCFS_MEMFILE;
        procfsCpuFile = PROCFS_CPUINFO;
        procfsStatFile = PROCFS_STAT;
        jiffyLengthInMillis = JIFFY_LENGTH_IN_MILLIS;
        cpuUsageCalculator = new CpuUsageCalculator(jiffyLengthInMillis);
        ramSize = 0L;
        swapSize = 0L;
        ramSizeFree = 0L;
        swapSizeFree = 0L;
        inactiveSize = 0L;
        numProcessors = 0;
        readMemInfoFile = false;
        readCpuInfoFile = false;
    }

    static class CpuUsageCalculator {
        static BigInteger systemCpuTime = BigInteger.ZERO;
        static BigInteger lastSystemCpuTime = BigInteger.ZERO;
        static BigInteger jiffyLengthInMillis;
        static long sampleTime;
        static long lastSampleTime;
        static float cpuUsage;
        static long MINIMUM_UPDATE_INTERVAL;

        public CpuUsageCalculator(long jiffyLengthInMillis) {
            CpuUsageCalculator.jiffyLengthInMillis = BigInteger.valueOf(jiffyLengthInMillis);
            cpuUsage = -1.0f;
            sampleTime = -1L;
            lastSampleTime = -1L;
            MINIMUM_UPDATE_INTERVAL = 10L * jiffyLengthInMillis;
        }

        public float getCpuTrackerUsagePercent() {
            if (lastSampleTime == -1L || lastSampleTime > sampleTime) {
                lastSampleTime = sampleTime;
                lastSystemCpuTime = systemCpuTime;
                return cpuUsage;
            }
            if (sampleTime > lastSampleTime + MINIMUM_UPDATE_INTERVAL) {
                cpuUsage = systemCpuTime.subtract(lastSystemCpuTime).floatValue() * 100.0f / (float)(sampleTime - lastSampleTime);
                lastSampleTime = sampleTime;
                lastSystemCpuTime = systemCpuTime;
            }
            return cpuUsage;
        }

        public void updateElapsedJiffies(BigInteger elapedJiffies, long sampleTime) {
            systemCpuTime = elapedJiffies.multiply(jiffyLengthInMillis);
            CpuUsageCalculator.sampleTime = sampleTime;
        }
    }

    static class FileParse {
        static LineParse parse;
        static String file;

        public FileParse(String file, LineParse parse) {
            FileParse.parse = parse;
            FileParse.file = file;
            parse.prepare();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void parse() {
            BufferedReader in = null;
            InputStreamReader fReader = null;
            try {
                fReader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
                in = new BufferedReader(fReader);
            }
            catch (FileNotFoundException f) {
                return;
            }
            try {
                String str = in.readLine();
                while (str != null) {
                    if (parse.parseLine(str)) {
                        break;
                    }
                    str = in.readLine();
                }
            }
            catch (IOException io) {
                LOG.warn("Error reading the stream " + io);
            }
            finally {
                try {
                    fReader.close();
                    try {
                        in.close();
                    }
                    catch (IOException i) {
                        LOG.warn("Error closing the stream " + in);
                    }
                }
                catch (IOException i) {
                    LOG.warn("Error closing the stream " + fReader);
                }
            }
        }
    }

    public static abstract class LineParse {
        public abstract void prepare();

        public abstract boolean parseLine(String var1);
    }
}

