/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import backtype.storm.utils.WorkerClassLoader;
import com.alibaba.jstorm.client.ConfigExtension;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LogUtils.class);
    public static final String LOGBACK_CLASSIC = "ch.qos.logback.classic";
    public static final String LOGBACK_CLASSIC_LOGGER = "ch.qos.logback.classic.Logger";
    public static final String LOGBACK_CLASSIC_LEVEL = "ch.qos.logback.classic.Level";
    public static final String LOG4J_CLASSIC = "org.apache.log4j";
    public static final String LOG4J_CLASSIC_LOGGER = "org.apache.log4j.Logger";
    public static final String LOG4J_CLASSIC_LEVEL = "org.apache.log4j.Level";
    public static Long lastChangeTS = 0L;

    private LogUtils() {
    }

    public static void update(Map conf) {
        Map<String, String> logLevelConfig;
        try {
            logLevelConfig = ConfigExtension.getChangeLogLevelConfig(conf);
        }
        catch (ClassCastException e) {
            LOG.error("the log level config is not the type of Map<String, String> !");
            return;
        }
        Long confTs = ConfigExtension.getChangeLogLevelTimeStamp(conf);
        if (logLevelConfig != null && confTs != null && confTs > lastChangeTS) {
            LogUtils.updateLogLevel(logLevelConfig);
            if (WorkerClassLoader.isEnable()) {
                WorkerClassLoader.switchThreadContext();
                LogUtils.updateLogLevel(logLevelConfig);
                WorkerClassLoader.restoreThreadContext();
            }
            lastChangeTS = confTs;
        }
    }

    private static void updateLogLevel(Map<String, String> logLevelConfig) {
        for (Map.Entry<String, String> entry : logLevelConfig.entrySet()) {
            String loggerName = entry.getKey();
            String level = entry.getValue();
            boolean logback = LogUtils.setLogBackLevel(loggerName, level);
            boolean log4j = LogUtils.setLog4jLevel(loggerName, level);
            if (logback || log4j) continue;
            LOG.warn("Couldn't set logback level to {} for the logger '{}'", (Object)level, (Object)loggerName);
        }
    }

    public static boolean setLogBackLevel(String loggerName, String logLevel) {
        String logLevelUpper = logLevel == null ? "OFF" : logLevel.toUpperCase();
        try {
            Logger loggerObtained;
            Package logbackPackage = Package.getPackage(LOGBACK_CLASSIC);
            if (logbackPackage == null) {
                LOG.warn("Logback is not in the classpath!");
                return false;
            }
            if (loggerName == null || loggerName.trim().isEmpty()) {
                loggerName = (String)LogUtils.getFieldVaulue(LOGBACK_CLASSIC_LOGGER, "ROOT_LOGGER_NAME");
            }
            if ((loggerObtained = LoggerFactory.getLogger((String)loggerName)) == null) {
                LOG.warn("No logger for the name: {}", (Object)loggerName);
                return false;
            }
            Object logLevelObj = LogUtils.getFieldVaulue(LOGBACK_CLASSIC_LEVEL, logLevelUpper);
            if (logLevelObj == null) {
                LOG.warn("No such log level: {}", (Object)logLevelUpper);
                return false;
            }
            Class[] paramTypes = new Class[]{logLevelObj.getClass()};
            Object[] params = new Object[]{logLevelObj};
            Class<?> clz = Class.forName(LOGBACK_CLASSIC_LOGGER);
            Method method = clz.getMethod("setLevel", paramTypes);
            method.invoke((Object)loggerObtained, params);
            LOG.info("LogBack level set to {} for the logger '{}'", (Object)logLevelUpper, (Object)loggerName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean setLog4jLevel(String loggerName, String logLevel) {
        String logLevelUpper = logLevel == null ? "OFF" : logLevel.toUpperCase();
        try {
            Object loggerObtained;
            Method method;
            Package log4jPackage = Package.getPackage(LOG4J_CLASSIC);
            if (log4jPackage == null) {
                LOG.warn("Log4j is not in the classpath!");
                return false;
            }
            Class<?> clz = Class.forName(LOG4J_CLASSIC_LOGGER);
            if (loggerName == null || loggerName.trim().isEmpty()) {
                method = clz.getMethod("getRootLogger", new Class[0]);
                loggerObtained = method.invoke(null, new Object[0]);
                loggerName = "ROOT";
            } else {
                method = clz.getMethod("getLogger", String.class);
                loggerObtained = method.invoke(null, loggerName);
            }
            if (loggerObtained == null) {
                LOG.warn("No logger for the name: {}", (Object)loggerName);
                return false;
            }
            Object logLevelObj = LogUtils.getFieldVaulue(LOG4J_CLASSIC_LEVEL, logLevelUpper);
            if (logLevelObj == null) {
                LOG.warn("No such log level: {}", (Object)logLevelUpper);
                return false;
            }
            Class[] paramTypes = new Class[]{logLevelObj.getClass()};
            Object[] params = new Object[]{logLevelObj};
            Method method2 = clz.getMethod("setLevel", paramTypes);
            method2.invoke(loggerObtained, params);
            LOG.info("Log4j level set to {} for the logger '{}'", (Object)logLevelUpper, (Object)loggerName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Object getFieldVaulue(String fullClassName, String fieldName) {
        try {
            Class<?> clazz = Class.forName(fullClassName);
            Field field = clazz.getField(fieldName);
            return field.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ignored) {
            return null;
        }
    }
}

