/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import com.alibaba.jstorm.utils.JStormUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetWorkUtils {
    private static Logger LOG = LoggerFactory.getLogger(NetWorkUtils.class);

    public static String hostname() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            LOG.error("local_hostname", (Throwable)e);
        }
        return hostname;
    }

    public static String ip() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.error("local_hostname", (Throwable)e);
        }
        return hostname;
    }

    public static int tryPort(int port) throws IOException {
        ServerSocket socket = new ServerSocket(port);
        int rtn = socket.getLocalPort();
        socket.close();
        return rtn;
    }

    public static int getAvailablePort() {
        return NetWorkUtils.availablePort(0);
    }

    public static int availablePort(int prefered) {
        int rtn = -1;
        try {
            rtn = NetWorkUtils.tryPort(prefered);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rtn;
    }

    public static String host2Ip(String host) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            LOG.warn("NetWorkUtil can't transfer hostname(" + host + ") to ip, return hostname", (Throwable)e);
            return host;
        }
        return address.getHostAddress();
    }

    public static List<String> host2Ip(List<String> servers) {
        if (servers == null || servers.size() == 0) {
            return new ArrayList<String>();
        }
        HashSet<String> ret = new HashSet<String>();
        for (String server : servers) {
            InetAddress ia;
            if (StringUtils.isBlank((String)server)) continue;
            try {
                ia = InetAddress.getByName(server);
            }
            catch (UnknownHostException e) {
                LOG.info("Fail to get address of ", (Object)server);
                continue;
            }
            if (ia.isLoopbackAddress() || ia.isAnyLocalAddress()) {
                ret.add(NetWorkUtils.ip());
                continue;
            }
            ret.add(ia.getHostAddress());
        }
        return JStormUtils.mk_list(ret);
    }

    public static String ip2Host(String ip) {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            LOG.warn("NetWorkUtil can't transfer ip(" + ip + ") to hostname, return ip", (Throwable)e);
            return ip;
        }
        return address.getHostName();
    }

    public static boolean equals(String host1, String host2) {
        if (StringUtils.equalsIgnoreCase((String)host1, (String)host2)) {
            return true;
        }
        if (host1 == null || host2 == null) {
            return false;
        }
        String ip1 = NetWorkUtils.host2Ip(host1);
        String ip2 = NetWorkUtils.host2Ip(host2);
        return StringUtils.equalsIgnoreCase((String)ip1, (String)ip2);
    }

    public static void main(String[] args) {
        ArrayList<String> servers = new ArrayList<String>();
        servers.add("localhost");
        System.out.println(NetWorkUtils.host2Ip(servers));
    }
}

