/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    static Logger LOG = LoggerFactory.getLogger(PathUtils.class);
    public static final String SEPERATOR = "/";

    public static List<String> tokenize_path(String path) {
        String[] toks = path.split(SEPERATOR);
        ArrayList<String> rtn = new ArrayList<String>();
        for (String str : toks) {
            if (str.isEmpty()) continue;
            rtn.add(str);
        }
        return rtn;
    }

    public static String toks_to_path(List<String> toks) {
        StringBuffer buff = new StringBuffer();
        buff.append(SEPERATOR);
        int size = toks.size();
        for (int i = 0; i < size; ++i) {
            buff.append(toks.get(i));
            if (i >= size - 1) continue;
            buff.append(SEPERATOR);
        }
        return buff.toString();
    }

    public static String normalize_path(String path) {
        String rtn = PathUtils.toks_to_path(PathUtils.tokenize_path(path));
        return rtn;
    }

    public static String parent_path(String path) {
        List<String> toks = PathUtils.tokenize_path(path);
        int size = toks.size();
        if (size > 0) {
            toks.remove(size - 1);
        }
        return PathUtils.toks_to_path(toks);
    }

    public static String full_path(String parent, String name) {
        return PathUtils.normalize_path(parent + SEPERATOR + name);
    }

    public static boolean exists_file(String path) {
        return new File(path).exists();
    }

    public static void rmr(String path) throws IOException {
        LOG.debug("Rmr path " + path);
        if (PathUtils.exists_file(path)) {
            FileUtils.forceDelete((File)new File(path));
        }
    }

    public static void local_mkdirs(String path) throws IOException {
        LOG.debug("Making dirs at" + path);
        FileUtils.forceMkdir((File)new File(path));
    }

    public static void rmpath(String path) {
        LOG.debug("Removing path " + path);
        boolean isdelete = new File(path).delete();
        if (!isdelete) {
            throw new RuntimeException("Failed to delete " + path);
        }
    }

    public static void touch(String path) throws IOException {
        LOG.debug("Touching file at " + path);
        boolean success = new File(path).createNewFile();
        if (!success) {
            throw new RuntimeException("Failed to touch " + path);
        }
    }

    public static List<String> read_dir_contents(String dir) {
        ArrayList<String> rtn = new ArrayList<String>();
        if (PathUtils.exists_file(dir)) {
            File[] list2;
            for (File f : list2 = new File(dir).listFiles()) {
                rtn.add(f.getName());
            }
        }
        return rtn;
    }

    public static String getCanonicalPath(String fileName) {
        String ret = null;
        File file = new File(fileName);
        if (file.exists()) {
            try {
                ret = file.getCanonicalPath();
            }
            catch (IOException e) {
                LOG.error("", (Throwable)e);
            }
        } else {
            LOG.warn(fileName + " doesn't exist ");
        }
        return ret;
    }

    public static String join(String ... pathList) {
        return Joiner.on((String)File.separator).join((Object[])pathList);
    }

    public static void mv(String src, String dest) {
        try {
            FileUtils.moveFile((File)new File(src), (File)new File(dest));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

