/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import backtype.storm.utils.Utils;
import com.alibaba.jstorm.client.ConfigExtension;
import com.alibaba.jstorm.cluster.StormConfig;
import com.alibaba.jstorm.utils.JStormServerUtils;
import com.alibaba.jstorm.utils.JStormUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessLauncher.class);

    public static int getSleepSeconds() {
        HashMap conf = null;
        try {
            conf = Utils.readStormConfig();
        }
        catch (Exception e) {
            conf = new HashMap();
        }
        return ConfigExtension.getProcessLauncherSleepSeconds(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block12: {
            System.out.println("Enviroment:" + System.getenv());
            System.out.println("Properties:" + System.getProperties());
            String workerId = System.getenv("jstorm.workerId");
            if (StringUtils.isNotBlank((String)workerId)) {
                Map conf = Utils.readStormConfig();
                StormConfig.validate_distributed_mode(conf);
                String pidDir = StormConfig.worker_pids_root(conf, workerId);
                JStormServerUtils.createPid(pidDir);
            }
            int sleepSeconds = ProcessLauncher.getSleepSeconds();
            int ret = -1;
            try {
                if (System.getenv("REDIRECT") != null && System.getenv("REDIRECT").equals("true")) {
                    ProcessBuilder pb = new ProcessBuilder(args);
                    Process p = pb.start();
                    LogWriter err = null;
                    LogWriter in = null;
                    try {
                        err = new LogWriter(p.getErrorStream(), LOG);
                        err.start();
                        in = new LogWriter(p.getInputStream(), LOG);
                        in.start();
                        ret = p.waitFor();
                        break block12;
                    }
                    finally {
                        if (err != null) {
                            err.close();
                        }
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                LauncherThread launcher = new LauncherThread(args);
                launcher.start();
                Thread.sleep(sleepSeconds * 1000);
                launcher.interrupt();
                ret = launcher.getResult();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                System.out.println("Begin to exit:" + ret);
                JStormUtils.haltProcess(ret);
            }
        }
    }

    private static class LauncherThread
    extends Thread {
        private String[] args;
        private int ret = 0;

        public LauncherThread(String[] args) {
            this.args = args;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process p;
            ProcessBuilder pb = new ProcessBuilder(this.args);
            try {
                p = pb.start();
            }
            catch (IOException e1) {
                this.ret = -1;
                System.out.println("Failed to start " + this.args + "\n" + e1);
                return;
            }
            try {
                this.ret = p.waitFor();
                LOG.info(JStormUtils.getOutput(p.getErrorStream()));
                LOG.info(JStormUtils.getOutput(p.getInputStream()));
                LOG.info("!!!! Wokrer shutdown quickly !!!!");
            }
            catch (InterruptedException e) {
                this.ret = 0;
                System.out.println("Successfully start process");
            }
            catch (Throwable e) {
                LOG.error("Unknow exception" + e.getCause(), e);
            }
            finally {
                System.out.println("Begin to exit:" + this.ret);
                System.exit(this.ret);
            }
        }

        public int getResult() {
            return this.ret;
        }
    }

    private static class LogWriter
    extends Thread {
        private Logger logger;
        private BufferedReader in;

        public LogWriter(InputStream in, Logger logger) {
            this.in = new BufferedReader(new InputStreamReader(in));
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger logger = this.logger;
            BufferedReader in = this.in;
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    logger.info(line);
                }
            }
            catch (IOException e) {
                logger.error("Internal ERROR", (Throwable)e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("Internal ERROR", (Throwable)e);
                }
            }
        }

        public void close() throws Exception {
            this.join();
        }
    }
}

