/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import com.alibaba.jstorm.utils.ExpiredCallback;
import com.alibaba.jstorm.utils.TimeOutMap;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;

public class RotatingMap<K, V>
implements TimeOutMap<K, V> {
    private static final int DEFAULT_NUM_BUCKETS = 3;
    private Deque<Map<K, V>> _buckets;
    private ExpiredCallback _callback;
    private final Object lock = new Object();
    private boolean isSingleThread;

    public RotatingMap(int numBuckets, ExpiredCallback<K, V> callback, boolean isSingleThread) {
        this.isSingleThread = isSingleThread;
        if (numBuckets < 2) {
            throw new IllegalArgumentException("numBuckets must be >= 2");
        }
        if (isSingleThread) {
            this._buckets = new LinkedList<Map<K, V>>();
            for (int i = 0; i < numBuckets; ++i) {
                this._buckets.add(new HashMap());
            }
        } else {
            this._buckets = new LinkedBlockingDeque<Map<K, V>>();
            for (int i = 0; i < numBuckets; ++i) {
                this._buckets.add(new ConcurrentHashMap());
            }
        }
        this._callback = callback;
    }

    public RotatingMap(ExpiredCallback<K, V> callback) {
        this(3, callback, false);
    }

    public RotatingMap(int numBuckets) {
        this(numBuckets, null, false);
    }

    public RotatingMap(int numBuckets, boolean isSingleThread) {
        this(numBuckets, null, isSingleThread);
    }

    public Map<K, V> rotate() {
        Map<K, V> dead = this._buckets.removeLast();
        if (this.isSingleThread) {
            this._buckets.addFirst(new HashMap());
        } else {
            this._buckets.addFirst(new ConcurrentHashMap());
        }
        if (this._callback != null) {
            for (Map.Entry<K, V> entry : dead.entrySet()) {
                this._callback.expire(entry.getKey(), entry.getValue());
            }
        }
        return dead;
    }

    @Override
    public boolean containsKey(K key) {
        for (Map<K, V> bucket : this._buckets) {
            if (!bucket.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(K key) {
        for (Map<K, V> bucket : this._buckets) {
            V v = bucket.get(key);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    @Override
    public void putHead(K key, V value) {
        this._buckets.peekFirst().put(key, value);
    }

    @Override
    public void put(K key, V value) {
        Iterator<Map<K, V>> it = this._buckets.iterator();
        Map<K, V> bucket = it.next();
        bucket.put(key, value);
        while (it.hasNext()) {
            bucket = it.next();
            bucket.remove(key);
        }
    }

    @Override
    public Object remove(K key) {
        for (Map<K, V> bucket : this._buckets) {
            V value = bucket.remove(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public int size() {
        int size = 0;
        for (Map<K, V> bucket : this._buckets) {
            size += bucket.size();
        }
        return size;
    }
}

