/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import com.alibaba.jstorm.utils.IntervalCheck;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunCounter
implements Serializable {
    private static final long serialVersionUID = 2177944366059817622L;
    private static final Logger LOG = LoggerFactory.getLogger(RunCounter.class);
    private AtomicLong total = new AtomicLong(0L);
    private AtomicLong times = new AtomicLong(0L);
    private AtomicLong values = new AtomicLong(0L);
    private IntervalCheck intervalCheck;
    private final String id;

    public RunCounter() {
        this("", RunCounter.class);
    }

    public RunCounter(String id) {
        this(id, RunCounter.class);
    }

    public RunCounter(Class tclass) {
        this(tclass.getName(), tclass);
    }

    public RunCounter(String id, Class tclass) {
        this.id = id;
        this.intervalCheck = new IntervalCheck();
        this.intervalCheck.setInterval(60L);
    }

    public Double count(long value) {
        long totalValue = this.total.incrementAndGet();
        long timesValue = this.times.incrementAndGet();
        long v = this.values.addAndGet(value);
        Double pass = this.intervalCheck.checkAndGet();
        if (pass != null) {
            this.times.set(0L);
            this.values.set(0L);
            Double tps = (double)timesValue / pass;
            StringBuilder sb = new StringBuilder();
            sb.append(this.id);
            sb.append(", tps:" + tps);
            sb.append(", avg:" + (double)v / (double)timesValue);
            sb.append(", total:" + totalValue);
            LOG.info(sb.toString());
            return tps;
        }
        return null;
    }

    public void cleanup() {
        LOG.info(this.id + ", total:" + this.total);
    }

    public IntervalCheck getIntervalCheck() {
        return this.intervalCheck;
    }

    public static void main(String[] args) {
    }
}

