/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import backtype.storm.generated.Bolt;
import backtype.storm.generated.ComponentCommon;
import backtype.storm.generated.ComponentObject;
import backtype.storm.generated.GlobalStreamId;
import backtype.storm.generated.Grouping;
import backtype.storm.generated.JavaObject;
import backtype.storm.generated.JavaObjectArg;
import backtype.storm.generated.NullStruct;
import backtype.storm.generated.StormTopology;
import backtype.storm.generated.StreamInfo;
import backtype.storm.generated.TopologyInitialStatus;
import backtype.storm.grouping.CustomStreamGrouping;
import backtype.storm.task.IBolt;
import backtype.storm.utils.Utils;
import com.alibaba.jstorm.cluster.StormStatus;
import com.alibaba.jstorm.daemon.nimbus.StatusType;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Thrift {
    private static Logger LOG = LoggerFactory.getLogger(Thrift.class);
    public static StormTopology._Fields[] STORM_TOPOLOGY_FIELDS = null;
    public static StormTopology._Fields[] SPOUT_FIELDS = new StormTopology._Fields[]{StormTopology._Fields.SPOUTS, StormTopology._Fields.STATE_SPOUTS};

    public static StormStatus topologyInitialStatusToStormStatus(TopologyInitialStatus tStatus) {
        if (tStatus.equals((Object)TopologyInitialStatus.ACTIVE)) {
            return new StormStatus(StatusType.active);
        }
        return new StormStatus(StatusType.inactive);
    }

    public static CustomStreamGrouping instantiateJavaObject(JavaObject obj) {
        List<JavaObjectArg> args = obj.get_args_list();
        Class[] paraTypes = new Class[args.size()];
        Object[] paraValues = new Object[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            JavaObjectArg arg = args.get(i);
            paraValues[i] = arg.getFieldValue();
            paraTypes[i] = ((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.INT_ARG) ? Integer.class : (((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.LONG_ARG) ? Long.class : (((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.STRING_ARG) ? String.class : (((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.BOOL_ARG) ? Boolean.class : (((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.BINARY_ARG) ? ByteBuffer.class : (((JavaObjectArg._Fields)arg.getSetField()).equals((Object)JavaObjectArg._Fields.DOUBLE_ARG) ? Double.class : Object.class)))));
        }
        try {
            Class<?> clas = Class.forName(obj.get_full_class_name());
            Constructor<?> cons = clas.getConstructor(paraTypes);
            return (CustomStreamGrouping)cons.newInstance(paraValues);
        }
        catch (Exception e) {
            LOG.error("instantiate_java_object fail", (Throwable)e);
            return null;
        }
    }

    public static Grouping._Fields groupingType(Grouping grouping) {
        return (Grouping._Fields)grouping.getSetField();
    }

    public static List<String> fieldGrouping(Grouping grouping) {
        if (!Grouping._Fields.FIELDS.equals((Object)Thrift.groupingType(grouping))) {
            throw new IllegalArgumentException("Tried to get grouping fields from non fields grouping");
        }
        return grouping.get_fields();
    }

    public static boolean isGlobalGrouping(Grouping grouping) {
        if (Grouping._Fields.FIELDS.equals((Object)Thrift.groupingType(grouping))) {
            return Thrift.fieldGrouping(grouping).isEmpty();
        }
        return false;
    }

    public static int parallelismHint(ComponentCommon component_common) {
        int phint = component_common.get_parallelism_hint();
        if (!component_common.is_set_parallelism_hint()) {
            phint = 1;
        }
        return phint;
    }

    public static StreamInfo directOutputFields(List<String> fields) {
        return new StreamInfo(fields, true);
    }

    public static StreamInfo outputFields(List<String> fields) {
        return new StreamInfo(fields, false);
    }

    public static Grouping mkFieldsGrouping(List<String> fields) {
        return Grouping.fields(fields);
    }

    public static Grouping mkDirectGrouping() {
        return Grouping.direct(new NullStruct());
    }

    public static Grouping mkAllGrouping() {
        return Grouping.all(new NullStruct());
    }

    private static ComponentCommon mkComponentcommon(Map<GlobalStreamId, Grouping> inputs, HashMap<String, StreamInfo> output_spec, Integer parallelism_hint) {
        ComponentCommon ret = new ComponentCommon(inputs, output_spec);
        if (parallelism_hint != null) {
            ret.set_parallelism_hint(parallelism_hint);
        }
        return ret;
    }

    public static Bolt mkBolt(Map<GlobalStreamId, Grouping> inputs, IBolt bolt, HashMap<String, StreamInfo> output, Integer p) {
        ComponentCommon common = Thrift.mkComponentcommon(inputs, output, p);
        byte[] boltSer = Utils.serialize(bolt);
        ComponentObject component = ComponentObject.serialized_java(boltSer);
        return new Bolt(component, common);
    }

    static {
        Set<StormTopology._Fields> keys = StormTopology.metaDataMap.keySet();
        STORM_TOPOLOGY_FIELDS = new StormTopology._Fields[keys.size()];
        keys.toArray(STORM_TOPOLOGY_FIELDS);
    }
}

