/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import com.alibaba.jstorm.utils.ExpiredCallback;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.TimeOutMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class TimeCacheMap<K, V>
implements TimeOutMap<K, V> {
    private static final int DEFAULT_NUM_BUCKETS = 3;
    private LinkedList<HashMap<K, V>> _buckets;
    private final Object _lock = new Object();
    private Thread _cleaner;
    private ExpiredCallback _callback;

    public TimeCacheMap(int expirationSecs, int numBuckets, ExpiredCallback<K, V> callback) {
        if (numBuckets < 2) {
            throw new IllegalArgumentException("numBuckets must be >= 2");
        }
        this._buckets = new LinkedList();
        for (int i = 0; i < numBuckets; ++i) {
            this._buckets.add(new HashMap());
        }
        this._callback = callback;
        long expirationMillis = (long)expirationSecs * 1000L;
        final long sleepTime = expirationMillis / (long)(numBuckets - 1);
        this._cleaner = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block3: while (true) {
                    dead = null;
                    JStormUtils.sleepMs(sleepTime);
                    var2_2 = TimeCacheMap.access$000(TimeCacheMap.this);
                    synchronized (var2_2) {
                        dead = (Map)TimeCacheMap.access$100(TimeCacheMap.this).removeLast();
                        TimeCacheMap.access$100(TimeCacheMap.this).addFirst(new HashMap<K, V>());
                    }
                    if (TimeCacheMap.access$200(TimeCacheMap.this) == null) continue;
                    i$ = dead.entrySet().iterator();
                    while (true) {
                        if (i$.hasNext()) ** break;
                        continue block3;
                        entry = i$.next();
                        TimeCacheMap.access$200(TimeCacheMap.this).expire(entry.getKey(), entry.getValue());
                    }
                    break;
                }
            }
        });
        this._cleaner.setDaemon(true);
        this._cleaner.start();
    }

    public TimeCacheMap(int expirationSecs, ExpiredCallback<K, V> callback) {
        this(expirationSecs, 3, callback);
    }

    public TimeCacheMap(int expirationSecs) {
        this(expirationSecs, 3);
    }

    public TimeCacheMap(int expirationSecs, int numBuckets) {
        this(expirationSecs, numBuckets, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        Object object = this._lock;
        synchronized (object) {
            for (HashMap hashMap : this._buckets) {
                if (!hashMap.containsKey(key)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        Object object = this._lock;
        synchronized (object) {
            for (HashMap hashMap : this._buckets) {
                if (!hashMap.containsKey(key)) continue;
                return hashMap.get(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putHead(K key, V value) {
        Object object = this._lock;
        synchronized (object) {
            this._buckets.getFirst().put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        Object object = this._lock;
        synchronized (object) {
            Iterator it = this._buckets.iterator();
            HashMap bucket = (HashMap)it.next();
            bucket.put(key, value);
            while (it.hasNext()) {
                bucket = (HashMap)it.next();
                bucket.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(K key) {
        Object object = this._lock;
        synchronized (object) {
            for (HashMap hashMap : this._buckets) {
                if (!hashMap.containsKey(key)) continue;
                return hashMap.remove(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this._lock;
        synchronized (object) {
            int size = 0;
            for (HashMap hashMap : this._buckets) {
                size += hashMap.size();
            }
            return size;
        }
    }

    public void cleanup() {
        this._cleaner.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> buildMap() {
        HashMap ret = new HashMap();
        Object object = this._lock;
        synchronized (object) {
            for (HashMap hashMap : this._buckets) {
                ret.putAll(hashMap);
            }
            return ret;
        }
    }

    static /* synthetic */ Object access$000(TimeCacheMap x0) {
        return x0._lock;
    }

    static /* synthetic */ LinkedList access$100(TimeCacheMap x0) {
        return x0._buckets;
    }

    static /* synthetic */ ExpiredCallback access$200(TimeCacheMap x0) {
        return x0._callback;
    }
}

