/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeCacheQueue<K> {
    public static final int DEFAULT_NUM_BUCKETS = 3;
    protected LinkedList<LinkedBlockingDeque<K>> _buckets;
    protected final Object _lock = new Object();
    protected Thread _cleaner;
    protected ExpiredCallback _callback;

    public TimeCacheQueue(int expirationSecs, int numBuckets, ExpiredCallback<K> callback) {
        if (numBuckets < 2) {
            throw new IllegalArgumentException("numBuckets must be >= 2");
        }
        this._buckets = new LinkedList();
        for (int i = 0; i < numBuckets; ++i) {
            this._buckets.add(new LinkedBlockingDeque());
        }
        this._callback = callback;
        long expirationMillis = (long)expirationSecs * 1000L;
        final long sleepTime = expirationMillis / (long)(numBuckets - 1);
        this._cleaner = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                try {
                    block5: while (true) {
                        dead = null;
                        Thread.sleep(sleepTime);
                        var2_3 = TimeCacheQueue.this._lock;
                        synchronized (var2_3) {
                            dead = TimeCacheQueue.this._buckets.removeLast();
                            TimeCacheQueue.this._buckets.addFirst(new LinkedBlockingDeque<E>());
                        }
                        if (TimeCacheQueue.this._callback == null) continue;
                        i$ = dead.iterator();
                        while (true) {
                            if (i$.hasNext()) ** break;
                            continue block5;
                            entry = i$.next();
                            TimeCacheQueue.this._callback.expire(entry);
                        }
                        break;
                    }
                }
                catch (InterruptedException var1_2) {
                    return;
                }
            }
        });
        this._cleaner.setDaemon(true);
        this._cleaner.start();
    }

    public TimeCacheQueue(int expirationSecs, ExpiredCallback<K> callback) {
        this(expirationSecs, 3, callback);
    }

    public TimeCacheQueue(int expirationSecs) {
        this(expirationSecs, 3, null);
    }

    public TimeCacheQueue(int expirationSecs, int numBuckets) {
        this(expirationSecs, numBuckets, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K entry) {
        Object object = this._lock;
        synchronized (object) {
            for (LinkedBlockingDeque linkedBlockingDeque : this._buckets) {
                if (!linkedBlockingDeque.contains(entry)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K poll() {
        Object object = this._lock;
        synchronized (object) {
            Iterator<LinkedBlockingDeque<K>> itor = this._buckets.descendingIterator();
            while (itor.hasNext()) {
                LinkedBlockingDeque<K> bucket = itor.next();
                K entry = bucket.poll();
                if (entry == null) continue;
                return entry;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(K entry) {
        Object object = this._lock;
        synchronized (object) {
            LinkedBlockingDeque<K> bucket = this._buckets.getFirst();
            bucket.offer(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K entry) {
        Object object = this._lock;
        synchronized (object) {
            for (LinkedBlockingDeque linkedBlockingDeque : this._buckets) {
                if (!linkedBlockingDeque.contains(entry)) continue;
                linkedBlockingDeque.remove(entry);
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this._lock;
        synchronized (object) {
            int size = 0;
            for (LinkedBlockingDeque linkedBlockingDeque : this._buckets) {
                size += linkedBlockingDeque.size();
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this._cleaner.interrupt();
        }
        finally {
            super.finalize();
        }
    }

    public static class DefaultExpiredCallback<K>
    implements ExpiredCallback<K> {
        protected static final Logger LOG = LoggerFactory.getLogger(DefaultExpiredCallback.class);
        protected String queueName;

        public DefaultExpiredCallback(String queueName) {
            this.queueName = queueName;
        }

        @Override
        public void expire(K entry) {
            LOG.info("TimeCacheQueue " + this.queueName + " entry:" + entry + ", timeout");
        }
    }

    public static interface ExpiredCallback<K> {
        public void expire(K var1);
    }
}

