/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeFormat {
    public static Logger log = LoggerFactory.getLogger(TimeFormat.class);
    public static final long ONE_SECOND_MILLISECONDS = 1000L;
    public static final long ONE_MINUTE_SECONDS = 60L;
    public static final long ONE_HOUR_MINUTES = 60L;
    public static final long ONE_DAY_HOURS = 24L;
    public static final long ONE_MINUTE_MILLISECONDS = 60000L;
    public static final long ONE_HOUR_MILLISECONDS = 3600000L;
    public static final long ONE_DAY_MILLISECONDS = 86400000L;

    public static Date convertDate(String dateStr, String format) {
        Date date = null;
        try {
            if (format != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
                date = simpleDateFormat.parse(dateStr);
            } else {
                date = new Date(dateStr);
            }
        }
        catch (Exception ex) {
            log.error("Failed to convert " + dateStr + " to Date, format:" + format);
            return null;
        }
        return date;
    }

    public static String convertStr(Date date, String format) {
        String ret = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            ret = sdf.format(date);
        }
        catch (Exception e) {
            log.error("Failed to convert " + date + " to String, format:" + format);
            return null;
        }
        return ret;
    }

    public static Date getYear(String dateStr) {
        return TimeFormat.convertDate(dateStr, "yyyy");
    }

    public static String getYear(Date date) {
        return TimeFormat.convertStr(date, "yyyy");
    }

    public static Date getMonth(String dateStr) {
        return TimeFormat.convertDate(dateStr, "yyyyMM");
    }

    public static String getMonth(Date date) {
        return TimeFormat.convertStr(date, "yyyyMM");
    }

    public static Date getDay(String dateStr) {
        return TimeFormat.convertDate(dateStr, "yyyyMMdd");
    }

    public static String getDay(Date date) {
        return TimeFormat.convertStr(date, "yyyyMMdd");
    }

    public static Date getHour(String dateStr) {
        return TimeFormat.convertDate(dateStr, "yyyyMMddHH");
    }

    public static String getHour(Date date) {
        return TimeFormat.convertStr(date, "yyyyMMddHH");
    }

    public static Date getMinute(String dateStr) {
        return TimeFormat.convertDate(dateStr, "yyyyMMddHHmm");
    }

    public static String getMinute(Date date) {
        return TimeFormat.convertStr(date, "yyyyMMddHHmm");
    }

    public static Date getSecond(String dateStr) {
        return TimeFormat.convertDate(dateStr, "yyyyMMddHHmmss");
    }

    public static String getSecond(Date date) {
        return TimeFormat.convertStr(date, "yyyyMMddHHmmss");
    }

    public static String getHourMin(String dateStr) {
        Date date = TimeFormat.convertDate(dateStr, null);
        if (date == null) {
            return null;
        }
        return TimeFormat.getHourMin(date);
    }

    public static String getHourMin(Date date) {
        String output = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            output = sdf.format(date);
        }
        catch (Exception e) {
            return null;
        }
        return output;
    }

    public static Date getToday() {
        Date now = new Date();
        String todayStr = TimeFormat.getDay(now);
        return TimeFormat.getDay(todayStr);
    }

    public static Date getYesterday() {
        Date now = new Date();
        Calendar yesterdayCal = Calendar.getInstance();
        yesterdayCal.setTime(now);
        yesterdayCal.add(5, -1);
        String yesterdayStr = TimeFormat.getDay(yesterdayCal.getTime());
        return TimeFormat.getDay(yesterdayStr);
    }

    public static long getDayNum(Date date) {
        long passMs = date.getTime() + 28800000L;
        return passMs / 1000L / 60L / 60L / 24L;
    }

    public static void main(String[] args) {
        Date date = new Date();
        String dateStr = TimeFormat.getDay(date);
        Date newDate = TimeFormat.getDay(dateStr);
        System.out.println("new date:" + newDate);
        Date current = new Date();
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.setTime(current);
        tomorrow.add(5, 1);
        tomorrow.set(9, 0);
        tomorrow.set(10, 2);
        tomorrow.set(12, 0);
        Date startTime = tomorrow.getTime();
        long hourdiff = (startTime.getTime() - current.getTime()) / 3600000L;
        System.out.println("Current:" + current + ", tomorrow" + startTime + ", diff hour" + hourdiff);
    }
}

