/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.utils;

import backtype.storm.utils.Time;
import com.alibaba.jstorm.metric.AsmWindow;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtils {
    public static final long NS_PER_MS = 1000000L;
    public static final long MS_PER_SEC = 1000L;
    public static final long NS_PER_US = 1000L;
    public static final long US_PER_MS = 1000L;
    public static final int ONE_SEC = 1;
    public static final int SEC_PER_MIN = 60;
    public static final int SEC_PER_DAY = 86400;

    public static int current_time_secs() {
        return (int)(Time.currentTimeMillis() / 1000L);
    }

    public static int time_delta(int time_secs) {
        return TimeUtils.current_time_secs() - time_secs;
    }

    public static long time_delta_ms(long time_ms) {
        return System.currentTimeMillis() - time_ms;
    }

    public static boolean isTimeAligned() {
        return TimeUtils.current_time_secs() % 86400 % 60 == 0;
    }

    public static int secOffset() {
        return TimeUtils.current_time_secs() % 86400 % 60;
    }

    public static int secOffset(long ts) {
        return (int)(ts % 86400L % 60L);
    }

    public static int winSecOffset(long ts, int window) {
        return (int)(ts / 1000L % 86400L % (long)window);
    }

    public static long alignTimeToWin(long ts, int win) {
        if (win != AsmWindow.D1_WINDOW) {
            long curTimeSec = ts / 1000L;
            return (curTimeSec - curTimeSec % (long)win) * 1000L;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(ts);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(10);
        int min = cal.get(12);
        int sec = cal.get(13);
        if (sec + min + hour > 0) {
            cal.set(year, month, day + 1, 0, 0, 0);
        }
        return cal.getTimeInMillis();
    }

    public static long alignTimeToMin(long ts) {
        return TimeUtils.alignTimeToWin(ts, AsmWindow.M1_WINDOW);
    }

    public static String toTimeStr(Date time) {
        int hour = time.getHours();
        int min = time.getMinutes();
        StringBuilder sb = new StringBuilder();
        if (hour < 10) {
            sb.append(0).append(hour);
        } else {
            sb.append(hour);
        }
        sb.append(":");
        if (min < 10) {
            sb.append(0).append(min);
        } else {
            sb.append(min);
        }
        return sb.toString();
    }

    public static String format(int curTimeSec) {
        return TimeUtils.format(new Date((long)curTimeSec * 1000L), "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(Date time, String fmt) {
        SimpleDateFormat df = new SimpleDateFormat(fmt);
        return df.format(time);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new Date(TimeUtils.alignTimeToWin(System.currentTimeMillis(), AsmWindow.M1_WINDOW)));
        System.out.println(new Date(TimeUtils.alignTimeToWin(System.currentTimeMillis(), AsmWindow.M10_WINDOW)));
        System.out.println(new Date(TimeUtils.alignTimeToWin(System.currentTimeMillis(), AsmWindow.H2_WINDOW)));
        System.out.println(new Date(TimeUtils.alignTimeToWin(System.currentTimeMillis(), AsmWindow.D1_WINDOW)));
        Calendar cal = Calendar.getInstance();
        cal.set(2015, 6, 23, 0, 0, 0);
        System.out.println(new Date(TimeUtils.alignTimeToWin(cal.getTimeInMillis(), AsmWindow.D1_WINDOW)));
        System.out.println(TimeUtils.format(TimeUtils.current_time_secs()));
    }
}

