/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.zk;

import backtype.storm.utils.Utils;
import com.alibaba.jstorm.cluster.Cluster;
import com.alibaba.jstorm.cluster.ClusterState;
import com.alibaba.jstorm.cluster.DistributedClusterState;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkTool {
    private static final Logger LOG = LoggerFactory.getLogger(ZkTool.class);
    public static final String READ_CMD = "read";
    public static final String RM_CMD = "rm";
    public static final String LIST_CMD = "list";
    public static final String CLEAN_CMD = "clean";
    private static Map conf;

    public static void usage() {
        System.out.println("Read ZK node's data, please do as following:");
        System.out.println(ZkTool.class.getName() + " read zkpath");
        System.out.println("\nDelete topology backup assignment, please do as following:");
        System.out.println(ZkTool.class.getName() + " rm topologyname");
        System.out.println("\nlist subdirectory of zkPath , please do as following:");
        System.out.println(ZkTool.class.getName() + " list zkpath");
        System.out.println("\nDelete all nodes about a topologyId of zk , please do as following:");
        System.out.println(ZkTool.class.getName() + " clean topologyId");
    }

    public static String getData(DistributedClusterState zkClusterState, String path) throws Exception {
        byte[] data = zkClusterState.get_data(path, false);
        if (data == null || data.length == 0) {
            return null;
        }
        Object obj = Utils.deserialize(data, null);
        return obj.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void list(String path) {
        try (DistributedClusterState zkClusterState = null;){
            conf.put("storm.zookeeper.root", "/");
            zkClusterState = new DistributedClusterState(conf);
            List<String> children = zkClusterState.get_children(path, false);
            if (children == null || children.isEmpty()) {
                System.out.println("No children of " + path);
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("Zk node children of " + path + "\n");
                for (String str : children) {
                    sb.append(" " + str + ",");
                }
                sb.append("\n");
                System.out.println(sb.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanTopology(String topologyId) {
        try (DistributedClusterState zkClusterState = null;){
            zkClusterState = new DistributedClusterState(conf);
            String rootDir = String.valueOf(conf.get("storm.zookeeper.root"));
            String assignmentPath = "/assignments/" + topologyId;
            String stormBase = "/topology/" + topologyId;
            String taskbeats = "/taskbeats/" + topologyId;
            String tasks = "/tasks/" + topologyId;
            String taskerrors = "/taskerrors/" + topologyId;
            String monitor = "/monitor/" + topologyId;
            if (zkClusterState.node_existed(assignmentPath, false)) {
                try {
                    zkClusterState.delete_node(assignmentPath);
                }
                catch (Exception e) {
                    LOG.error("Could not remove assignments for " + topologyId, (Throwable)e);
                }
            } else {
                System.out.println(" node of " + rootDir + assignmentPath + " isn't existed ");
            }
            if (zkClusterState.node_existed(stormBase, false)) {
                try {
                    zkClusterState.delete_node(stormBase);
                }
                catch (Exception e) {
                    LOG.error("Failed to remove storm base for " + topologyId, (Throwable)e);
                }
            } else {
                System.out.println(" node of " + rootDir + stormBase + " isn't existed ");
            }
            if (zkClusterState.node_existed(taskbeats, false)) {
                try {
                    zkClusterState.delete_node(taskbeats);
                }
                catch (Exception e) {
                    LOG.error("Failed to remove taskbeats for " + topologyId, (Throwable)e);
                }
            } else {
                System.out.println(" node of " + rootDir + taskbeats + " isn't existed ");
            }
            if (zkClusterState.node_existed(tasks, false)) {
                try {
                    zkClusterState.delete_node(tasks);
                }
                catch (Exception e) {
                    LOG.error("Failed to remove tasks for " + topologyId, (Throwable)e);
                }
            } else {
                System.out.println(" node of " + rootDir + tasks + " isn't existed ");
            }
            if (zkClusterState.node_existed(taskerrors, false)) {
                try {
                    zkClusterState.delete_node(taskerrors);
                }
                catch (Exception e) {
                    LOG.error("Failed to remove taskerrors for " + topologyId, (Throwable)e);
                }
            } else {
                System.out.println(" node of " + rootDir + taskerrors + " isn't existed ");
            }
            if (zkClusterState.node_existed(monitor, false)) {
                try {
                    zkClusterState.delete_node(monitor);
                }
                catch (Exception e) {
                    LOG.error("Failed to remove monitor for " + topologyId, (Throwable)e);
                }
            } else {
                System.out.println(" node of " + rootDir + monitor + " isn't existed ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readData(String path) {
        try (DistributedClusterState zkClusterState = null;){
            conf.put("storm.zookeeper.root", "/");
            zkClusterState = new DistributedClusterState(conf);
            String data = ZkTool.getData(zkClusterState, path);
            if (data == null) {
                System.out.println("No data of " + path);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");
            sb.append("Zk node " + path + "\n");
            sb.append("Readable data:" + data + "\n");
            sb.append("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n\n");
            System.out.println(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rmBakTopology(String topologyName) {
        try (DistributedClusterState zkClusterState = null;){
            zkClusterState = new DistributedClusterState(conf);
            String path = Cluster.ASSIGNMENTS_BAK_SUBTREE;
            List<String> bakTopologys = zkClusterState.get_children(path, false);
            for (String tid : bakTopologys) {
                if (!tid.equals(topologyName)) continue;
                System.out.println("Find backup " + topologyName);
                String topologyPath = ZkTool.assignment_bak_path(topologyName);
                zkClusterState.delete_node(topologyPath);
                System.out.println("Successfully delete topology " + topologyName + " backup Assignment");
                return;
            }
            System.out.println("No backup topology " + topologyName + " Assignment");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Invalid parameter");
            ZkTool.usage();
            return;
        }
        conf = Utils.readStormConfig();
        if (args[0].equalsIgnoreCase(READ_CMD)) {
            ZkTool.readData(args[1]);
        } else if (args[0].equalsIgnoreCase(RM_CMD)) {
            ZkTool.rmBakTopology(args[1]);
        } else if (args[0].equalsIgnoreCase(LIST_CMD)) {
            ZkTool.list(args[1]);
        } else if (args[0].equalsIgnoreCase(CLEAN_CMD)) {
            ZkTool.cleanTopology(args[1]);
        }
    }

    public static String assignment_bak_path(String id) {
        return Cluster.ASSIGNMENTS_BAK_SUBTREE + "/" + id;
    }

    public static ClusterState mk_distributed_cluster_state(Map _conf) throws Exception {
        return new DistributedClusterState(_conf);
    }

    public static Map<String, String> get_followers(ClusterState cluster_state) throws Exception {
        HashMap ret = Maps.newHashMap();
        List<String> followers = cluster_state.get_children(Cluster.NIMBUS_SLAVE_SUBTREE, false);
        if (followers == null || followers.size() == 0) {
            return ret;
        }
        for (String follower : followers) {
            if (follower == null) continue;
            String uptime = new String(cluster_state.get_data(Cluster.NIMBUS_SLAVE_SUBTREE + "/" + follower, false));
            ret.put(follower, uptime);
        }
        return ret;
    }
}

