/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.jstorm.zk;

import backtype.storm.utils.Utils;
import com.alibaba.jstorm.callback.DefaultWatcherCallBack;
import com.alibaba.jstorm.callback.WatcherCallBack;
import com.alibaba.jstorm.utils.JStormUtils;
import com.alibaba.jstorm.utils.PathUtils;
import com.alibaba.jstorm.zk.Factory;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.CuratorListener;
import org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zookeeper {
    private static Logger LOG = LoggerFactory.getLogger(Zookeeper.class);

    public CuratorFramework mkClient(Map conf, List<String> servers, Object port, String root) {
        return this.mkClient(conf, servers, port, root, new DefaultWatcherCallBack());
    }

    public CuratorFramework mkClient(Map conf, List<String> servers, Object port, String root, final WatcherCallBack watcher) {
        CuratorFramework fk = Utils.newCurator(conf, servers, port, root);
        fk.getCuratorListenable().addListener((Object)new CuratorListener(){

            public void eventReceived(CuratorFramework _fk, CuratorEvent e) throws Exception {
                if (e.getType().equals((Object)CuratorEventType.WATCHED)) {
                    WatchedEvent event = e.getWatchedEvent();
                    watcher.execute(event.getState(), event.getType(), event.getPath());
                }
            }
        });
        fk.getUnhandledErrorListenable().addListener((Object)new UnhandledErrorListener(){

            public void unhandledError(String msg, Throwable error) {
                String errmsg = "Unrecoverable Zookeeper error, halting process: " + msg;
                LOG.error(errmsg, error);
                JStormUtils.halt_process(1, "Unrecoverable Zookeeper error");
            }
        });
        fk.start();
        return fk;
    }

    public String createNode(CuratorFramework zk, String path, byte[] data, CreateMode mode) throws Exception {
        String npath = PathUtils.normalize_path(path);
        return (String)((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)zk.create().withMode(mode)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath(npath, data);
    }

    public String createNode(CuratorFramework zk, String path, byte[] data) throws Exception {
        return this.createNode(zk, path, data, CreateMode.PERSISTENT);
    }

    public boolean existsNode(CuratorFramework zk, String path, boolean watch) throws Exception {
        Stat stat = null;
        stat = watch ? (Stat)((BackgroundPathable)zk.checkExists().watched()).forPath(PathUtils.normalize_path(path)) : (Stat)zk.checkExists().forPath(PathUtils.normalize_path(path));
        return stat != null;
    }

    public void deleteNode(CuratorFramework zk, String path) throws Exception {
        zk.delete().forPath(PathUtils.normalize_path(path));
    }

    public void mkdirs(CuratorFramework zk, String path) throws Exception {
        String npath = PathUtils.normalize_path(path);
        if (npath.equals("/")) {
            return;
        }
        if (this.existsNode(zk, npath, false)) {
            return;
        }
        this.mkdirs(zk, PathUtils.parent_path(npath));
        try {
            this.createNode(zk, npath, JStormUtils.barr((byte)7), CreateMode.PERSISTENT);
        }
        catch (KeeperException e) {
            LOG.warn("zookeeper mkdirs for path" + path, (Throwable)e);
        }
    }

    public Integer getVersion(CuratorFramework zk, String path, boolean watch) throws Exception {
        String npath = PathUtils.normalize_path(path);
        Stat stat = null;
        if (this.existsNode(zk, npath, watch)) {
            stat = watch ? (Stat)((BackgroundPathable)zk.checkExists().watched()).forPath(PathUtils.normalize_path(path)) : (Stat)zk.checkExists().forPath(PathUtils.normalize_path(path));
            return stat.getVersion();
        }
        return null;
    }

    public byte[] getData(CuratorFramework zk, String path, boolean watch) throws Exception {
        String npath = PathUtils.normalize_path(path);
        try {
            if (this.existsNode(zk, npath, watch)) {
                if (watch) {
                    return (byte[])((BackgroundPathable)zk.getData().watched()).forPath(npath);
                }
                return (byte[])zk.getData().forPath(npath);
            }
        }
        catch (KeeperException e) {
            LOG.error("zookeeper getdata for path" + path, (Throwable)e);
        }
        return null;
    }

    public List<String> getChildren(CuratorFramework zk, String path, boolean watch) throws Exception {
        String npath = PathUtils.normalize_path(path);
        if (watch) {
            return (List)((BackgroundPathable)zk.getChildren().watched()).forPath(npath);
        }
        return (List)zk.getChildren().forPath(npath);
    }

    public Stat setData(CuratorFramework zk, String path, byte[] data) throws Exception {
        String npath = PathUtils.normalize_path(path);
        return (Stat)zk.setData().forPath(npath, data);
    }

    public boolean exists(CuratorFramework zk, String path, boolean watch) throws Exception {
        return this.existsNode(zk, path, watch);
    }

    public void deletereRcursive(CuratorFramework zk, String path) throws Exception {
        String npath = PathUtils.normalize_path(path);
        if (this.existsNode(zk, npath, false)) {
            zk.delete().guaranteed().deletingChildrenIfNeeded().forPath(npath);
        }
    }

    public static Factory mkInprocessZookeeper(String localdir, int port) throws IOException, InterruptedException {
        LOG.info("Starting inprocess zookeeper at port " + port + " and dir " + localdir);
        File localfile = new File(localdir);
        ZooKeeperServer zk = new ZooKeeperServer(localfile, localfile, 2000);
        Factory factory = new Factory(new InetSocketAddress(port), 0);
        factory.startup(zk);
        return factory;
    }

    public void shutdownInprocessZookeeper(Factory handle) {
        handle.shutdown();
    }
}

