/*
 * Decompiled with CFR 0.152.
 */
package storm.trident.drpc;

import backtype.storm.drpc.DRPCInvocationsClient;
import backtype.storm.generated.AuthorizationException;
import backtype.storm.generated.DistributedRPCInvocations;
import backtype.storm.utils.ServiceRegistry;
import backtype.storm.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.json.simple.JSONValue;
import storm.trident.operation.MultiReducer;
import storm.trident.operation.TridentCollector;
import storm.trident.operation.TridentMultiReducerContext;
import storm.trident.tuple.TridentTuple;

public class ReturnResultsReducer
implements MultiReducer<ReturnResultsState> {
    boolean local;
    Map conf;
    Map<List, DRPCInvocationsClient> _clients = new HashMap<List, DRPCInvocationsClient>();

    @Override
    public void prepare(Map conf, TridentMultiReducerContext context) {
        this.conf = conf;
        this.local = conf.get("storm.cluster.mode").equals("local");
    }

    @Override
    public ReturnResultsState init(TridentCollector collector) {
        return new ReturnResultsState();
    }

    @Override
    public void execute(ReturnResultsState state, int streamIndex, TridentTuple input, TridentCollector collector) {
        if (streamIndex == 0) {
            state.returnInfo = input.getString(0);
        } else {
            state.results.add(input);
        }
    }

    @Override
    public void complete(ReturnResultsState state, TridentCollector collector) {
        if (state.returnInfo != null) {
            DistributedRPCInvocations.Iface client;
            String result2 = JSONValue.toJSONString(state.results);
            Map retMap = (Map)JSONValue.parse((String)state.returnInfo);
            final String host = (String)retMap.get("host");
            final int port = Utils.getInt(retMap.get("port"));
            String id = (String)retMap.get("id");
            if (this.local) {
                client = (DistributedRPCInvocations.Iface)ServiceRegistry.getService(host);
            } else {
                ArrayList server = new ArrayList(){
                    {
                        this.add(host);
                        this.add(port);
                    }
                };
                if (!this._clients.containsKey(server)) {
                    try {
                        this._clients.put(server, new DRPCInvocationsClient(this.conf, host, port));
                    }
                    catch (TTransportException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                client = this._clients.get(server);
            }
            try {
                client.result(id, result2);
            }
            catch (AuthorizationException aze) {
                collector.reportError((Throwable)((Object)aze));
            }
            catch (TException e) {
                collector.reportError(e);
            }
        }
    }

    @Override
    public void cleanup() {
        for (DRPCInvocationsClient c : this._clients.values()) {
            c.close();
        }
    }

    public static class ReturnResultsState {
        List<TridentTuple> results = new ArrayList<TridentTuple>();
        String returnInfo;

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

